/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.gradle.api.DefaultTask;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.springframework.boot.gradle.dsl.SpringBootExtension;
import org.springframework.boot.loader.tools.MainClassFinder;

@DisableCachingByDefault(because="Not worth caching")
public class ResolveMainClassName
extends DefaultTask {
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private final RegularFileProperty outputFile = this.getProject().getObjects().fileProperty();
    private final Property<String> configuredMainClass = this.getProject().getObjects().property(String.class);
    private FileCollection classpath;

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.setClasspath((Object)classpath);
    }

    public void setClasspath(Object classpath) {
        this.classpath = this.getProject().files(new Object[]{classpath});
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    @Input
    @Optional
    public Property<String> getConfiguredMainClassName() {
        return this.configuredMainClass;
    }

    @TaskAction
    void resolveAndStoreMainClassName() throws IOException {
        File outputFile = (File)this.outputFile.getAsFile().get();
        outputFile.getParentFile().mkdirs();
        String mainClassName = this.resolveMainClassName();
        Files.write(outputFile.toPath(), mainClassName.getBytes(StandardCharsets.UTF_8), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private String resolveMainClassName() {
        String configuredMainClass = (String)this.configuredMainClass.getOrNull();
        if (configuredMainClass != null) {
            return configuredMainClass;
        }
        return this.getClasspath().filter(File::isDirectory).getFiles().stream().map(this::findMainClass).filter(Objects::nonNull).findFirst().orElse("");
    }

    private String findMainClass(File file) {
        try {
            return MainClassFinder.findSingleMainClass((File)file, (String)SPRING_BOOT_APPLICATION_CLASS_NAME);
        }
        catch (IOException ex) {
            return null;
        }
    }

    Provider<String> readMainClassName() {
        return this.outputFile.map((Transformer)new ClassNameReader());
    }

    static TaskProvider<ResolveMainClassName> registerForTask(String taskName, Project project, Callable<FileCollection> classpath) {
        TaskProvider resolveMainClassNameProvider = project.getTasks().register(taskName + "MainClassName", ResolveMainClassName.class, resolveMainClassName -> {
            resolveMainClassName.setDescription("Resolves the name of the application's main class for the " + taskName + " task.");
            resolveMainClassName.setGroup("build");
            resolveMainClassName.setClasspath(classpath);
            resolveMainClassName.getConfiguredMainClassName().convention(project.provider(() -> {
                String javaApplicationMainClass = ResolveMainClassName.getJavaApplicationMainClass(project);
                if (javaApplicationMainClass != null) {
                    return javaApplicationMainClass;
                }
                SpringBootExtension springBootExtension = (SpringBootExtension)project.getExtensions().findByType(SpringBootExtension.class);
                return (String)springBootExtension.getMainClass().getOrNull();
            }));
            resolveMainClassName.getOutputFile().set(project.getLayout().getBuildDirectory().file(taskName + "MainClassName"));
        });
        return resolveMainClassNameProvider;
    }

    private static String getJavaApplicationMainClass(Project project) {
        JavaApplication javaApplication = (JavaApplication)project.getExtensions().findByType(JavaApplication.class);
        if (javaApplication == null) {
            return null;
        }
        return (String)javaApplication.getMainClass().getOrNull();
    }

    private static final class ClassNameReader
    implements Transformer<String, RegularFile> {
        private ClassNameReader() {
        }

        public String transform(RegularFile file) {
            if (file.getAsFile().length() == 0L) {
                throw new InvalidUserDataException("Main class name has not been configured and it could not be resolved");
            }
            Path output = file.getAsFile().toPath();
            try {
                return new String(Files.readAllBytes(output), StandardCharsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException("Failed to read main class name from '" + output + "'");
            }
        }
    }
}

