/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.web;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.engine.SecurityLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.pac4j.jee.context.JEEContextFactory;
import org.pac4j.jee.context.session.JEESessionStore;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.pac4j.springframework.security.profile.SpringSecurityProfileManager;

public class SecurityFilter
implements Filter {
    private SecurityLogic securityLogic;
    private Config config;
    private String clients;
    private String authorizers;
    private String matchers;

    public SecurityFilter() {
    }

    public SecurityFilter(Config config) {
        this.config = config;
    }

    public SecurityFilter(Config config, String clients) {
        this(config);
        this.clients = clients;
    }

    public SecurityFilter(Config config, String clients, String authorizers) {
        this(config, clients);
        this.authorizers = authorizers;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain filterChain) throws IOException, ServletException {
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)this.config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        SecurityLogic bestLogic = FindBest.securityLogic((SecurityLogic)this.securityLogic, (Config)this.config, (SecurityLogic)DefaultSecurityLogic.INSTANCE);
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        WebContext context = FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{req, resp});
        bestLogic.perform(context, bestSessionStore, this.config, (ctx, session, profiles, parameters) -> {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return null;
        }, bestAdapter, this.clients, this.authorizers, this.matchers, new Object[0]);
    }

    public void destroy() {
    }

    public SecurityLogic getSecurityLogic() {
        return this.securityLogic;
    }

    public void setSecurityLogic(SecurityLogic securityLogic) {
        this.securityLogic = securityLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getClients() {
        return this.clients;
    }

    public void setClients(String clients) {
        this.clients = clients;
    }

    public String getAuthorizers() {
        return this.authorizers;
    }

    public void setAuthorizers(String authorizers) {
        this.authorizers = authorizers;
    }

    public String getMatchers() {
        return this.matchers;
    }

    public void setMatchers(String matchers) {
        this.matchers = matchers;
    }

    static {
        Config.setProfileManagerFactory((String)"SpringSecurityProfileManager", (ctx, session) -> new SpringSecurityProfileManager((WebContext)ctx, (SessionStore)session));
    }
}

