/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.security.web;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.exception.http.HttpAction;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.FindBest;
import org.pac4j.jee.context.JEEContextFactory;
import org.pac4j.jee.context.session.JEESessionStore;
import org.pac4j.jee.http.adapter.JEEHttpActionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class Pac4jEntryPoint
extends DefaultSecurityLogic
implements AuthenticationEntryPoint {
    private static final Logger LOGGER = LoggerFactory.getLogger(Pac4jEntryPoint.class);
    private Config config;
    private String clientName;

    public Pac4jEntryPoint() {
    }

    public Pac4jEntryPoint(Config config, String clientName) {
        this.config = config;
        this.clientName = clientName;
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        HttpAction action;
        WebContext context;
        HttpActionAdapter bestAdapter;
        if (this.config != null && CommonHelper.isNotBlank((String)this.clientName)) {
            SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)this.config, (SessionStore)JEESessionStore.INSTANCE);
            bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
            context = FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response});
            ArrayList<Client> currentClients = new ArrayList<Client>();
            Client client = (Client)this.config.getClients().findClient(this.clientName).orElseThrow(() -> new TechnicalException("Cannot find clientName: " + this.clientName));
            currentClients.add(client);
            try {
                if (this.startAuthentication(context, bestSessionStore, currentClients)) {
                    LOGGER.debug("Redirecting to identity provider for login");
                    this.saveRequestedUrl(context, bestSessionStore, currentClients, this.config.getClients().getAjaxRequestResolver());
                    action = this.redirectToIdentityProvider(context, bestSessionStore, currentClients);
                } else {
                    action = this.unauthorized(context, bestSessionStore, currentClients);
                }
            }
            catch (HttpAction e) {
                LOGGER.debug("extra HTTP action required in Pac4jEntryPoint: {}", (Object)e.getCode());
                action = e;
            }
        } else {
            throw new TechnicalException("The Pac4jEntryPoint has been defined without config, nor clientName: it must be defined in a <security:http> section with the pac4j SecurityFilter or CallbackFilter");
        }
        bestAdapter.adapt(action, context);
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String toString() {
        return CommonHelper.toNiceString(((Object)((Object)this)).getClass(), (Object[])new Object[]{"config", this.config, "clientName", this.clientName});
    }
}

