/*
 * Decompiled with CFR 0.152.
 */
package io.spring.gradle.dependencymanagement.internal.dsl;

import groovy.lang.Closure;
import io.spring.gradle.dependencymanagement.dsl.DependenciesHandler;
import io.spring.gradle.dependencymanagement.dsl.DependencyManagementHandler;
import io.spring.gradle.dependencymanagement.dsl.ImportsHandler;
import io.spring.gradle.dependencymanagement.internal.DependencyManagementContainer;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardDependenciesHandler;
import io.spring.gradle.dependencymanagement.internal.dsl.StandardImportsHandler;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;

class StandardDependencyManagementHandler
implements DependencyManagementHandler {
    private final DependencyManagementContainer container;
    private final Configuration configuration;

    StandardDependencyManagementHandler(DependencyManagementContainer container) {
        this(container, null);
    }

    StandardDependencyManagementHandler(DependencyManagementContainer container, Configuration configuration) {
        this.container = container;
        this.configuration = configuration;
    }

    @Override
    public void imports(Closure<?> closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)new StandardImportsHandler(this.container, this.configuration));
        closure.call();
    }

    @Override
    public void imports(Action<ImportsHandler> action) {
        action.execute((Object)new StandardImportsHandler(this.container, this.configuration));
    }

    @Override
    public void dependencies(Closure<?> closure) {
        closure.setResolveStrategy(1);
        closure.setDelegate((Object)new StandardDependenciesHandler(this.container, this.configuration));
        closure.call();
    }

    @Override
    public void dependencies(Action<DependenciesHandler> action) {
        action.execute((Object)new StandardDependenciesHandler(this.container, this.configuration));
    }

    @Override
    public Map<String, String> getImportedProperties() {
        return this.container.importedPropertiesForConfiguration(this.configuration);
    }

    @Override
    public Map<String, String> getManagedVersions() {
        return this.container.getManagedVersionsForConfiguration(this.configuration);
    }
}

