/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.wiki.commands;

import com.fasterxml.jackson.databind.JsonNode;
import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.extensions.wiki.model.Wikiconcat;
import de.unibamberg.minf.gtf.extensions.wiki.model.Wikilink;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import java.util.ArrayList;
import java.util.Collection;

public class WikiTextCommands
extends BaseCommands {
    public Collection<Wikiconcat> concatPreserveLinks(Object[] args) {
        if (args == null || args.length != 2) {
            return null;
        }
        ArrayList<Wikiconcat> result = new ArrayList<Wikiconcat>();
        Collection concatArgs = this.ensureCollection(args[0]);
        Collection linkArgs = this.ensureCollection(args[1]);
        ArrayList concatElements = new ArrayList(concatArgs.size());
        for (Object arg : concatArgs) {
            ArrayList<String> s;
            if (arg instanceof Collection) {
                s = new ArrayList(((Collection)arg).size());
                for (Object e : (Collection)arg) {
                    s.add(this.getAsSimpleValue(e).toString());
                }
                concatElements.add(s);
                continue;
            }
            s = new ArrayList<String>(1);
            s.add(this.getAsSimpleValue(arg).toString());
            concatElements.add(s);
        }
        if (concatElements.size() == 0) {
            return null;
        }
        ArrayList<Wikilink> linkElements = new ArrayList<Wikilink>(linkArgs.size());
        for (Object arg : linkArgs) {
            Wikilink link = null;
            if (arg instanceof NonterminalSyntaxTreeNode) {
                link = this.getLinkFromNonterminal((NonterminalSyntaxTreeNode)arg);
            }
            if (link == null) continue;
            linkElements.add(link);
        }
        for (Collection collection : concatElements) {
            StringBuilder stb = new StringBuilder();
            ArrayList<Wikilink> links = new ArrayList<Wikilink>();
            for (String e : collection) {
                String token = e.trim();
                if (token.length() > 0) {
                    for (Wikilink link : linkElements) {
                        if (!link.getTextmatch().equals(token)) continue;
                        link.setCharOffsetBegin(stb.length());
                        link.setCharOffsetEnd(link.getCharOffsetBegin() + token.length() - 1);
                        linkElements.remove(link);
                        links.add(link);
                        break;
                    }
                }
                stb.append(e);
            }
            Wikiconcat wc = new Wikiconcat();
            wc.setTextblock(stb.toString());
            wc.setLinks(links);
            result.add(wc);
        }
        return result;
    }

    private Wikilink getLinkFromNonterminal(NonterminalSyntaxTreeNode node) {
        JsonNode link;
        JsonNode n = node.getValue();
        if (n == null || n.isMissingNode()) {
            return null;
        }
        Wikilink l = new Wikilink();
        JsonNode match = n.findValue("LinkText");
        if (match != null && !match.isMissingNode()) {
            l.setTextmatch(match.textValue().trim());
        }
        if ((link = n.findValue("Link")) != null && !link.isMissingNode()) {
            l.setLink(link.textValue().trim());
        }
        if (l.getTextmatch() != null || l.getLink() != null) {
            return l;
        }
        return null;
    }
}

