/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.vocabulary.commands;

import de.unibamberg.minf.gtf.commands.BaseCommandDispatcher;
import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;
import de.unibamberg.minf.gtf.extensions.vocabulary.commands.SimpleVocabularyCommands;
import de.unibamberg.minf.gtf.model.vocabulary.Vocabulary;
import de.unibamberg.minf.gtf.model.vocabulary.VocabularyItem;
import de.unibamberg.minf.gtf.vocabulary.VocabularyEngine;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;

public class VocabularyCommandsDispatcher
extends BaseCommandDispatcher
implements CommandDispatcher {
    @Autowired
    private VocabularyEngine vocabularyEngine;
    private SimpleVocabularyCommands simple;

    public SimpleVocabularyCommands getSimple() {
        return this.simple;
    }

    public void setSimple(SimpleVocabularyCommands simple) {
        this.simple = simple;
    }

    public Object executeDirect(String command, Object[] args, ExecutionContext executionContext) throws CommandExecutionException {
        if (command.equals("SIMPLEREPLACE")) {
            if (!this.ensureCollectionSize(args, 4)) {
                throw new CommandExecutionException("SIMPLEREPLACE", "Argument count must be exactly 4");
            }
            return this.simple.replaceWithVocabularyValue(args, this.vocabularyEngine.getVocabularies());
        }
        if (command.equals("HIGHLIGHT")) {
            if (!this.ensureCollectionSize(args, 4)) {
                throw new CommandExecutionException("SIMPLEREPLACE", "Argument count must be exactly 4");
            }
            return this.simple.highlightVocabularyKeys(args, this.vocabularyEngine.getVocabularies());
        }
        if (command.equals("GETKEYS")) {
            if (this.vocabularyEngine.getVocabularies() == null || args[0] == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (Vocabulary v : this.vocabularyEngine.getVocabularies()) {
                if (!v.getLabel().equals(this.getAsSimpleValue(args[0])) || v.getItems() == null) continue;
                for (VocabularyItem vi : v.getItems()) {
                    result.add(vi.getLabel());
                }
            }
            if (result.isEmpty()) {
                return null;
            }
            return result;
        }
        return null;
    }
}

