/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.vocabulary.commands;

import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.model.vocabulary.Vocabulary;
import de.unibamberg.minf.gtf.model.vocabulary.VocabularyItem;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleVocabularyCommands
extends BaseCommands {
    private static final Logger logger = LoggerFactory.getLogger(SimpleVocabularyCommands.class);

    public <T extends Vocabulary> String replaceWithVocabularyValue(Object[] args, List<T> list) {
        String text = this.getAsSimpleValue(args[0]).toString();
        String vocabularyKey = args[1].toString();
        String condition = args[2].toString();
        String valueSelector = args[3].toString();
        for (Vocabulary v : list) {
            if (!v.getLabel().equals(vocabularyKey)) continue;
            for (VocabularyItem i : v.getItems()) {
                ArrayList<String> selector = new ArrayList<String>();
                selector.add("replacement");
                List<NonterminalSyntaxTreeNode> data = this.getNodesForStringSelector((NonterminalSyntaxTreeNode)i.getData(), selector);
                StringBuilder dataBuilder = new StringBuilder();
                for (NonterminalSyntaxTreeNode node : data) {
                    dataBuilder.append(node.getText());
                }
                if (!condition.equals("*") && (!condition.startsWith("!") || dataBuilder.toString().equals(condition.substring(1))) && (condition.startsWith("!") || !dataBuilder.toString().equals(condition))) continue;
                selector = new ArrayList();
                selector.add(valueSelector);
                data = this.getNodesForStringSelector((NonterminalSyntaxTreeNode)i.getData(), selector);
                dataBuilder = new StringBuilder();
                for (NonterminalSyntaxTreeNode node : data) {
                    dataBuilder.append(node.getText());
                }
                text = text.replace(i.getLabel(), dataBuilder.toString());
            }
        }
        return text;
    }

    public Object highlightVocabularyKeys(Object[] args, List<Vocabulary> list) {
        String text = this.getAsSimpleValue(args[0]).toString();
        String vocabularyKey = args[1].toString();
        String condition = args[2].toString();
        String formatString = args[3].toString();
        for (Vocabulary v : list) {
            if (!v.getLabel().equals(vocabularyKey)) continue;
            for (VocabularyItem i : v.getItems()) {
                ArrayList<String> selector = new ArrayList<String>();
                selector.add("replacement");
                List<NonterminalSyntaxTreeNode> data = this.getNodesForStringSelector((NonterminalSyntaxTreeNode)i.getData(), selector);
                StringBuilder dataBuilder = new StringBuilder();
                for (NonterminalSyntaxTreeNode node : data) {
                    dataBuilder.append(node.getText());
                }
                if (!condition.equals("*") && (!condition.startsWith("!") || dataBuilder.toString().equals(condition.substring(1))) && (condition.startsWith("!") || !dataBuilder.toString().equals(condition))) continue;
                text = text.replace(i.getLabel(), String.format(formatString, i.getLabel()));
            }
        }
        return text;
    }

    public List<NonterminalSyntaxTreeNode> getNodesForStringSelector(NonterminalSyntaxTreeNode parent, List<String> scopedSelector) {
        if (parent.getChildren() == null || parent.getChildren().size() == 0) {
            return new ArrayList<NonterminalSyntaxTreeNode>();
        }
        ArrayList<NonterminalSyntaxTreeNode> result = new ArrayList<NonterminalSyntaxTreeNode>();
        for (SyntaxTreeNode node : parent.getChildren()) {
            if (!(node instanceof NonterminalSyntaxTreeNode)) continue;
            if (node.getLabel().equals(scopedSelector.get(0))) {
                if (scopedSelector.size() == 1) {
                    result.add((NonterminalSyntaxTreeNode)node);
                    continue;
                }
                List<NonterminalSyntaxTreeNode> subResult = this.getNodesForStringSelector((NonterminalSyntaxTreeNode)node, scopedSelector.subList(1, scopedSelector.size()));
                if (subResult == null) continue;
                result.addAll(subResult);
                continue;
            }
            result.addAll(this.getNodesForStringSelector((NonterminalSyntaxTreeNode)node, scopedSelector));
        }
        return result;
    }
}

