/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.person.model.viaf;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.Record;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.RecordData;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.RecordDataSource;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.SearchResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SearchResponseDeserializer
extends JsonDeserializer<SearchResponse> {
    public SearchResponse deserialize(JsonParser jp, DeserializationContext ctx) throws IOException, JsonProcessingException {
        ObjectCodec oc = jp.getCodec();
        JsonNode node = (JsonNode)oc.readTree(jp);
        if (node == null | node instanceof MissingNode) {
            return null;
        }
        node = node.path("searchRetrieveResponse");
        SearchResponse resp = new SearchResponse();
        resp.setVersion(this.getValue(node, "version", String.class));
        resp.setNumberOfRecords(this.getValue(node, "numberOfRecords", Integer.class));
        resp.setResultSetIdleTime(this.getValue(node, "resultSetIdleTime", Integer.class));
        if (resp.getNumberOfRecords() > 0) {
            resp.setRecords(this.extractRecords(node.path("records")));
        }
        return resp;
    }

    private List<Record> extractRecords(JsonNode recordsNode) {
        if (recordsNode == null | !(recordsNode instanceof ArrayNode)) {
            return null;
        }
        ArrayList<Record> result = new ArrayList<Record>();
        for (JsonNode recordNode : (ArrayNode)recordsNode) {
            if (recordNode == null || !(recordNode instanceof ObjectNode)) continue;
            result.add(this.extractRecord(recordNode.path("record")));
        }
        return result;
    }

    private Record extractRecord(JsonNode recordNode) {
        Record r = new Record();
        r.setSchema(this.getValue(recordNode, "recordSchema", String.class));
        r.setPacking(this.getValue(recordNode, "recordPacking", String.class));
        JsonNode recordDataNode = recordNode.path("recordData");
        if (recordDataNode != null && !(recordDataNode instanceof MissingNode)) {
            JsonNode dataNode;
            if (recordDataNode.has("viafID")) {
                r.setViafId(this.getValue(recordDataNode.get("viafID"), "#text", String.class));
            }
            if (recordDataNode.has("nameType")) {
                r.setNameType(this.getValue(recordDataNode.get("nameType"), "#text", String.class));
            }
            if (recordDataNode.has("v:mainHeadings") && (dataNode = recordDataNode.path("v:mainHeadings")).has("data")) {
                dataNode = dataNode.path("data");
                ArrayList<RecordData> data = new ArrayList<RecordData>();
                if (dataNode instanceof ArrayNode) {
                    for (JsonNode dataNodeI : dataNode) {
                        data.add(this.extractData(dataNodeI));
                    }
                } else if (dataNode instanceof ObjectNode) {
                    data.add(this.extractData(dataNode));
                }
                r.setData(data);
            }
        }
        return r;
    }

    private RecordData extractData(JsonNode dataNode) {
        JsonNode sourcesNode;
        RecordData data = new RecordData();
        data.setText(this.getValue(dataNode, "text", String.class));
        if (dataNode.has("sources") && dataNode.get("sources").has("s") && (sourcesNode = dataNode.get("sources")).has("sid")) {
            data.setRecordDataSources(new ArrayList<RecordDataSource>());
            JsonNode sourceNode = sourcesNode.path("sid");
            if (sourceNode instanceof TextNode) {
                data.getRecordDataSources().add(new RecordDataSource(sourceNode.asText()));
            } else if (sourceNode instanceof ArrayNode) {
                for (JsonNode sourceNodeI : sourceNode) {
                    data.getRecordDataSources().add(new RecordDataSource(sourceNodeI.asText()));
                }
            }
        }
        return data;
    }

    private <T> T getValue(JsonNode node, String path, Class<T> primitiveType) {
        JsonNode childNode = node.get(path);
        if (childNode == null | childNode instanceof MissingNode) {
            return null;
        }
        if (primitiveType.equals(String.class)) {
            return primitiveType.cast(childNode.asText());
        }
        if (primitiveType.equals(Integer.class)) {
            return primitiveType.cast(childNode.asInt());
        }
        if (primitiveType.equals(Long.class)) {
            return primitiveType.cast(childNode.asLong());
        }
        if (primitiveType.equals(Float.class)) {
            return primitiveType.cast(childNode.asDouble());
        }
        if (primitiveType.equals(Double.class)) {
            return primitiveType.cast(childNode.asDouble());
        }
        if (primitiveType.equals(Boolean.class)) {
            return primitiveType.cast(childNode.asBoolean());
        }
        return null;
    }
}

