package de.unibamberg.minf.gtf.extensions.vocabulary.commands;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import de.unibamberg.minf.gtf.commands.BaseCommandDispatcher;
import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;
import de.unibamberg.minf.gtf.extensions.vocabulary.commands.LocaleCommands.CONVERSIONS;
import de.unibamberg.minf.gtf.model.vocabulary.Vocabulary;
import de.unibamberg.minf.gtf.model.vocabulary.VocabularyItem;
import de.unibamberg.minf.gtf.vocabulary.VocabularyEngine;
import lombok.Getter;
import lombok.Setter;

public class VocabularyCommandsDispatcher extends BaseCommandDispatcher implements CommandDispatcher {

	@Autowired private VocabularyEngine vocabularyEngine;
	
	@Getter @Setter private SimpleVocabularyCommands simple;
	@Getter @Setter private LocaleCommands locale;


	@Override
	public Object executeDirect(String command, Object[] args, ExecutionContext executionContext) throws CommandExecutionException {
		if (command.equals("ISO631")) {
			return locale.convertLanguageCode(args, CONVERSIONS.ISO631);
		} else if (command.equals("ISO631TTOB")) {
			return locale.convert631codes(args, CONVERSIONS.ISO631_T_TO_B);
		} else if (command.equals("ISO631BTOT")) {
			return locale.convert631codes(args, CONVERSIONS.ISO631_B_TO_T);
		} else if (command.equals("I18N")) {
			return locale.convertLanguageCode(args, CONVERSIONS.I18N);
		} else if (command.equals("SIMPLEREPLACE")) {
			if (!ensureCollectionSize(args, 4)) {
				throw new CommandExecutionException("SIMPLEREPLACE", "Argument count must be exactly 4");
			}
			return simple.replaceWithVocabularyValue(args, vocabularyEngine.getVocabularies());
		} else if (command.equals("HIGHLIGHT")) {
			if (!ensureCollectionSize(args, 4)) {
				throw new CommandExecutionException("SIMPLEREPLACE", "Argument count must be exactly 4");
			}
			return simple.highlightVocabularyKeys(args, vocabularyEngine.getVocabularies());
		} else if (command.equals("GETKEYS")) {
			if (vocabularyEngine.getVocabularies()==null || args[0]==null) {
				return null;
			}
			List<String> result = new ArrayList<>();
			
			for (Vocabulary v : vocabularyEngine.getVocabularies()) {
				if (v.getLabel().equals(getAsSimpleValue(args[0]))) {
					if (v.getItems()!=null) {
						for (VocabularyItem vi : v.getItems()) {
							result.add(vi.getLabel());
						}
					}
				}
			}
			if (result.isEmpty()) {
				return null;
			}
			return result;
		}
		return null;
	}
}
