package de.unibamberg.minf.gtf.extensions.vocabulary.commands;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.model.vocabulary.Vocabulary;
import de.unibamberg.minf.gtf.model.vocabulary.VocabularyItem;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class SimpleVocabularyCommands extends BaseCommands {
	private static final Logger logger = LoggerFactory.getLogger(SimpleVocabularyCommands.class);

	public <T extends Vocabulary> String replaceWithVocabularyValue(Object[] args, List<T> list) {
		
		String text = getAsSimpleValue(args[0]).toString();
		String vocabularyKey = args[1].toString();
		String condition = args[2].toString();
		String valueSelector = args[3].toString();
		List<NonterminalSyntaxTreeNode> data;
		StringBuilder dataBuilder;
	
		// TODO: Conceptual change necessary > all this transformation at some compile-time"
		for (Vocabulary v : list) {
			if(v.getLabel().equals(vocabularyKey)) {
				for (VocabularyItem i : v.getItems()) {
					List<String> selector = new ArrayList<String>();
					selector.add("replacement");
					data = getNodesForStringSelector((NonterminalSyntaxTreeNode)i.getData(), selector);
					dataBuilder = new StringBuilder();
					for (NonterminalSyntaxTreeNode node : data) {
						dataBuilder.append(node.getText());
					}
					
					if (condition.equals("*") || 
							condition.startsWith("!") && !dataBuilder.toString().equals(condition.substring(1)) ||
							!condition.startsWith("!") && dataBuilder.toString().equals(condition)) {
						
						selector = new ArrayList<String>();
						selector.add(valueSelector);
						data = getNodesForStringSelector((NonterminalSyntaxTreeNode)i.getData(), selector);
						dataBuilder = new StringBuilder();
						for (NonterminalSyntaxTreeNode node : data) {
							dataBuilder.append(node.getText());
						}
						
						text = text.replace(i.getLabel(), dataBuilder.toString());
					}
				}
			}
		} 
		
		return text;
	}
	

	public Object highlightVocabularyKeys(Object[] args, List<Vocabulary> list) {
		String text = getAsSimpleValue(args[0]).toString();
		String vocabularyKey = args[1].toString();
		String condition = args[2].toString();
		String formatString = args[3].toString();
		List<NonterminalSyntaxTreeNode> data;
		StringBuilder dataBuilder;
	
		// TODO: Conceptual change necessary > all this transformation at some compile-time"
		for (Vocabulary v : list) {
			if(v.getLabel().equals(vocabularyKey)) {
				for (VocabularyItem i : v.getItems()) {
					List<String> selector = new ArrayList<String>();
					selector.add("replacement");
					data = getNodesForStringSelector((NonterminalSyntaxTreeNode)i.getData(), selector);
					dataBuilder = new StringBuilder();
					for (NonterminalSyntaxTreeNode node : data) {
						dataBuilder.append(node.getText());
					}
					
					if (condition.equals("*") || 
							condition.startsWith("!") && !dataBuilder.toString().equals(condition.substring(1)) ||
							!condition.startsWith("!") && dataBuilder.toString().equals(condition)) {
						text = text.replace(i.getLabel(), String.format(formatString, i.getLabel()));
					}
				}
			}
		} 
		
		return text;
	}
	
	// TODO: All this needs some refactoring, also see class: NonterminalSyntaxTreeNode
	
	public List<NonterminalSyntaxTreeNode> getNodesForStringSelector(NonterminalSyntaxTreeNode parent, List<String> scopedSelector) {
		if (parent.getChildren()==null || parent.getChildren().size()==0) {
			return new ArrayList<NonterminalSyntaxTreeNode>();
		}
		List<NonterminalSyntaxTreeNode> result = new ArrayList<NonterminalSyntaxTreeNode>();
		for (SyntaxTreeNode node : parent.getChildren()) {
			if (node instanceof NonterminalSyntaxTreeNode) {
				if (node.getLabel().equals(scopedSelector.get(0))) {
					if (scopedSelector.size()==1) {
						result.add((NonterminalSyntaxTreeNode)node);
					} else {
						List<NonterminalSyntaxTreeNode> subResult = getNodesForStringSelector(((NonterminalSyntaxTreeNode)node), scopedSelector.subList(1, scopedSelector.size()));
						if (subResult!=null) {
							result.addAll(subResult);
						}
					}
				} else {
					result.addAll(getNodesForStringSelector((NonterminalSyntaxTreeNode)node, scopedSelector));
				}
			}
		}
		return result;
	}

}
