package de.unibamberg.minf.gtf.extensions.vocabulary.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.ibm.icu.util.ULocale;

import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;
import lombok.Getter;
import lombok.Setter;

public class LocaleCommands extends BaseCommands {

	public enum CONVERSIONS { ISO631, I18N, ISO631_B_TO_T, ISO631_T_TO_B }
	
	@Getter @Setter private Map<String, String> iso631_b_to_tMap;
	@Getter @Setter private Map<String, String> iso631_t_to_bMap;
	
    public LocaleCommands() {
    	iso631_b_to_tMap = new HashMap<>();
    	iso631_t_to_bMap = new HashMap<>();
    }
		
	public Object convertLanguageCode(Object[] args, CONVERSIONS conversion) throws CommandExecutionException {
		if (!ensureCollectionSize(args, 1)) {
			throw new CommandExecutionException("convertLanguage", "Argument count must be 1");
		}
		if (this.isCollectionType(args[0])) {
			Collection<?> c = this.ensureCollection(args[1]);
			if (c.isEmpty()) {
				return null;
			}
			String[] result = new String[c.size()];
			int i=0;
			ULocale locale;
			for (Object o : c) {
				if (o!=null) {
					locale = new ULocale(o.toString());
					result[i] = conversion==CONVERSIONS.ISO631 ? locale.getISO3Language() : locale.toLanguageTag();
				}
			}
			return result;
		} else {
			return conversion==CONVERSIONS.ISO631 ? new ULocale(args[0].toString()).getISO3Language() : new ULocale(args[0].toString()).toLanguageTag();
		}
	}
	
	public Object convert631codes(Object[] args, CONVERSIONS conversion) throws CommandExecutionException {
		if (!ensureCollectionSize(args, 1)) {
			throw new CommandExecutionException("convert631codes", "Argument count must be 1");
		}
		Map<String, String> conversionMap = conversion==CONVERSIONS.ISO631_B_TO_T ? this.iso631_b_to_tMap : this.iso631_t_to_bMap;
		if (this.isCollectionType(args[0])) {
			Collection<?> c = this.ensureCollection(args[1]);
			if (c.isEmpty()) {
				return null;
			}
			String[] result = new String[c.size()];
			int i=0;
			
			for (Object o : c) {
				if (o!=null && conversionMap.containsKey(o.toString())) {
					result[i] = conversionMap.get(o.toString());
				} else {
					result[i] = null;
				}
			}
			return result;
		} else {
			if (args[0].toString()!=null && conversionMap.containsKey(args[0].toString())) {
				return conversionMap.get(args[0].toString());
			} 
			return null;
		}
	}
}
