package de.unibamberg.minf.gtf.extensions.person.commands;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriUtils;

import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.Record;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.RecordData;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.RecordDataSource;
import de.unibamberg.minf.gtf.extensions.person.model.viaf.SearchResponse;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import de.unibamberg.minf.gtf.transformation.processing.params.OutputParam;

public class PersonReferencingCommands extends BaseCommands {
	private static final Logger logger = LoggerFactory.getLogger(PersonReferencingCommands.class);
	
	
	private RestTemplate restTemplate;

	private String url = "http://viaf.org/viaf/search";
	
	public RestTemplate getRestTemplate() { return restTemplate; }
	public void setRestTemplate(RestTemplate restTemplate) { this.restTemplate = restTemplate; }

	
	public Object lookupViafPerson(Object[] args) {
		
		HttpHeaders headers = new HttpHeaders();
		headers.set("Accept", MediaType.APPLICATION_JSON_VALUE);

		String query = "local.names+%s+%%22%s%%22";
		try {
			if (args.length==2) {
				query = String.format(query, "all", String.format("%s%%2C+%s", 
						UriUtils.encodeQueryParam(args[0] instanceof SyntaxTreeNode ? ((SyntaxTreeNode)args[0]).getText() : args[0].toString(), "UTF-8"), 
						UriUtils.encodeQueryParam(args[1] instanceof SyntaxTreeNode ? ((SyntaxTreeNode)args[1]).getText() : args[1].toString(), "UTF-8")));
			} else {
				query = String.format(query, "all", UriUtils.encodeQueryParam(args[0] instanceof SyntaxTreeNode ? ((SyntaxTreeNode)args[0]).getText() : args[0].toString(), "UTF-8"));
			}
			
			StringBuilder urlBuilder = new StringBuilder()
					.append(url)
					.append("?query=").append(query)
					.append("&httpAccept=application/json")
			        .append("&recordSchema=http://viaf.org/BriefVIAFCluster")
			        .append("&sortKey=holdingscount");
			
			return this.viafRecordToTree(restTemplate.getForObject(new URI(urlBuilder.toString()), SearchResponse.class));
		} catch (Exception e) {
			logger.error("Failed to retrieve valid VIAF response", e);
		}
		return null;
	}
	
	private List<OutputParam> viafRecordToTree(SearchResponse viafResp) {
		
		List<OutputParam> result = new ArrayList<OutputParam>();
		
		
		
		OutputParam pChild = new OutputParam();
		pChild.setLabel("PersonReferenceCount");
		pChild.setValue(viafResp.getNumberOfRecords());
		result.add(pChild);
			
		if (viafResp.getNumberOfRecords()>0) {
			pChild = new OutputParam();
			pChild.setLabel("Results");
			
			OutputParam nResult, nResultData, nHeadingData, nHeading, nSourceData;
			for (Record r : viafResp.getRecords()) {
				if (r.getNameType()==null || !r.getNameType().toLowerCase().equals("personal")) {
					continue;
				}
				nResult = new OutputParam();
				nResult.setLabel("Result");
				
				nResultData = new OutputParam();
				nResultData.setLabel("ViafId");
				nResultData.setValue(r.getViafId());
				nResult.addChildParameter(nResultData);
				
				nResultData = new OutputParam();
				nResultData.setLabel("NameType");
				nResultData.setValue(r.getNameType());
				nResult.addChildParameter(nResultData);
				
				
				for (RecordData rd : r.getData()) {
					nHeading = new OutputParam();
					nHeading.setLabel("Data");
			
					nHeadingData = new OutputParam();
					nHeadingData.setLabel("Text");
					nHeadingData.setValue(rd.getText());
					nHeading.addChildParameter(nHeadingData);
					
					for (RecordDataSource rds : rd.getRecordDataSources()) {
						nHeadingData = new OutputParam();
						nHeadingData.setLabel("Source");
						
						nSourceData = new OutputParam();
						nSourceData.setLabel("SourceId");
						nSourceData.setValue(rds.getSource());
						nHeadingData.addChildParameter(nSourceData);
						
						nSourceData = new OutputParam();
						nSourceData.setLabel("Id");
						nSourceData.setValue(rds.getId());
						nHeadingData.addChildParameter(nSourceData);
	
						nHeading.addChildParameter(nHeadingData);
					}
					nResult.addChildParameter(nHeading);
				}
				
				pChild.addChildParameter(nResult);
			}
			result.add(pChild);
		}
		
		return result;
	}
	
}
