package de.unibamberg.minf.gtf.extensions.person.commands;

import org.springframework.web.client.RestTemplate;

import de.unibamberg.minf.gtf.commands.BaseCommandDispatcher;
import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;

public class PersonCommandsDispatcher extends BaseCommandDispatcher implements CommandDispatcher {

	private PersonReferencingCommands person = null;
	private RestTemplate restTemplate;

	
	public RestTemplate getRestTemplate() { return restTemplate; }
	public void setRestTemplate(RestTemplate restTemplate) { this.restTemplate = restTemplate; }
	
	
	@Override
	public Object executeDirect(String command, Object[] args, ExecutionContext executionContext) throws CommandExecutionException {
		if (person==null) {
			person = new PersonReferencingCommands();
			person.setRestTemplate(restTemplate);
		}
		
		if (command.equals("VIAF::LOOKUP")) {
			if (!ensureCollectionSize(args, 1, 2)) {
				throw new CommandExecutionException("VIAF::LOOKUP", "Argument count must be 1 or 2");
			}
			return person.lookupViafPerson(args);
		}
		return null;
	}
}
