/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.geo.commands;

import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.extensions.geo.model.SimpleGeoNameResult;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class SimpleGeoCommands
extends BaseCommands {
    private static final Logger logger = LoggerFactory.getLogger(SimpleGeoCommands.class);
    private RestTemplate restTemplate;
    private String url = "http://api.geonames.org/findNearbyPlaceNameJSON";

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String fetchCityAsStringFromLatLng(Object[] args) {
        double lng;
        double lat;
        if (args == null || args.length != 2) {
            return null;
        }
        if (args[0] instanceof String) {
            lat = Double.parseDouble(args[0].toString());
        } else if (args[0] instanceof SyntaxTreeNode) {
            lat = Double.parseDouble(((SyntaxTreeNode)args[0]).getText());
        } else {
            return null;
        }
        if (args[1] instanceof String) {
            lng = Double.parseDouble(args[1].toString());
        } else if (args[1] instanceof SyntaxTreeNode) {
            lng = Double.parseDouble(((SyntaxTreeNode)args[1]).getText());
        } else {
            return null;
        }
        String call = this.url + "?lat=" + lat + "&lng=" + lng + "&username=dariahgtf";
        try {
            SimpleGeoNameResult result = (SimpleGeoNameResult)this.restTemplate.getForObject(call, SimpleGeoNameResult.class, new Object[0]);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Successfully executed [%s]", this.url));
            }
            return result.getGeonames().get(0).getName() + ", " + result.getGeonames().get(0).getCountryCode();
        }
        catch (Exception e) {
            logger.error(String.format("Error while executing [%s]", this.url), (Throwable)e);
            return null;
        }
    }
}

