/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.geo.commands;

import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.exceptions.CommandArgumentsException;
import de.unibamberg.minf.gtf.extensions.geo.exceptions.GeoConversionException;
import de.unibamberg.minf.gtf.extensions.geo.exceptions.InvalidCoordinatesException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoConversionCommands
extends BaseCommands {
    private static final Logger log = LoggerFactory.getLogger(GeoConversionCommands.class);

    public Object convertArgs(Object[] args) throws CommandArgumentsException, GeoConversionException {
        CommandArgumentsException ex = null;
        if (args == null || args.length < 3) {
            throw this.addExceptionArgument(ex, 0, "At least three arguments are required for this command, input and output type and at least one coordinate");
        }
        if (!(args[0] instanceof String)) {
            ex = this.addExceptionArgument(ex, 0, "First argument must be of type String and specify conversion input format (e.g. \"EPSG:4326\")");
        }
        if (!(args[1] instanceof String)) {
            ex = this.addExceptionArgument(ex, 0, "Second argument must be of type String and specify conversion output format (e.g. \"EPSG:4326\")");
        }
        if (ex != null) {
            throw ex;
        }
        try {
            List<double[]> result = this.isCollectionType(args[2]) ? this.convertCoordinateArrays(args) : this.convertSimpleCoordinate(ex, args);
            if (result.isEmpty()) {
                return null;
            }
            if (result.size() == 1) {
                return result.get(0);
            }
            return result;
        }
        catch (Exception e) {
            throw this.addExceptionArgument(ex, 2, "Failed to parse provided arguments: " + e.getMessage());
        }
    }

    public Object getSupportedCodesForAuthority(Object[] args) throws CommandArgumentsException, GeoConversionException {
        CommandArgumentsException ex = null;
        if (args == null || args.length != 1) {
            throw this.addExceptionArgument(ex, 0, "Exactly one argument required specifying the authority");
        }
        return this.getSupportedCodesForAuthority(args[0].toString());
    }

    private List<double[]> convertSimpleCoordinate(CommandArgumentsException ex, Object[] args) throws GeoConversionException, CommandArgumentsException {
        if (args.length == 4) {
            return this.convertCoordinates(args[0].toString(), args[1].toString(), new double[][]{this.parseCoord(Arrays.copyOfRange(args, 2, 5))});
        }
        if (args.length == 5) {
            return this.convertCoordinates(args[0].toString(), args[1].toString(), new double[][]{this.parseCoord(Arrays.copyOfRange(args, 2, 6))});
        }
        throw this.addExceptionArgument(ex, 0, "Providing one coordinate, arguments must be listed as x,y(,z)");
    }

    private List<double[]> convertCoordinateArrays(Object[] args) throws GeoConversionException, CommandArgumentsException {
        ArrayList coordinateArgs = new ArrayList(args.length - 2);
        Collections.addAll(coordinateArgs, Arrays.copyOfRange(args, 2, args.length));
        List<double[]> coordinates = this.collectCoordinates(coordinateArgs);
        return this.convertCoordinates(args[0].toString(), args[1].toString(), coordinates);
    }

    private List<double[]> collectCoordinates(Collection<?> args) throws GeoConversionException {
        Iterator<?> argsIterator = args.iterator();
        ArrayList<double[]> coordinates = new ArrayList<double[]>();
        while (argsIterator.hasNext()) {
            Collection cargs = this.ensureCollection(argsIterator.next());
            if (!cargs.iterator().hasNext()) continue;
            Collection arg = this.ensureCollection(cargs.iterator().next());
            if (this.isCollectionType(arg.iterator().next())) {
                coordinates.addAll(this.collectCoordinates(arg));
                continue;
            }
            coordinates.add(this.parseCoord(cargs.stream().toArray()));
        }
        return coordinates;
    }

    private double[] parseCoord(Object[] args) {
        double x = Double.parseDouble(args[0].toString());
        double y = Double.parseDouble(args[1].toString());
        if (args.length == 3 && args[2] != null) {
            return new double[]{x, y, Double.parseDouble(args[2].toString())};
        }
        return new double[]{x, y};
    }

    public List<double[]> convertCoordinates(String fromFormat, String toFormat, double[] ... coords) throws GeoConversionException {
        return this.convertCoordinates(fromFormat, toFormat, Arrays.asList(coords));
    }

    public List<double[]> convertCoordinates(String fromFormat, String toFormat, List<double[]> coordsList) throws GeoConversionException {
        ArrayList<double[]> result = new ArrayList<double[]>();
        try {
            MathTransform transform = this.getTransform(fromFormat, toFormat);
            for (double[] coord : coordsList) {
                if (coord.length < 2 || coord.length > 3) {
                    throw new InvalidCoordinatesException(String.format("Invalid coordinate array length %s, must be 2 (x,y) or 3 (x,y,z)", coord.length));
                }
                result.add(this.convertAndGetCoordinateArray(transform, new Coordinate(coord[0], coord[1], coord.length == 2 ? Double.NaN : coord[2])));
            }
            return result;
        }
        catch (Exception e) {
            log.error("Failed to execute coordinate conversion: " + e.getMessage());
            throw new GeoConversionException("Conversion of coordinates failed", e);
        }
    }

    public double[] convertCoordinate(String fromFormat, String toFormat, double x, double y) throws GeoConversionException {
        return this.convertCoordinate(fromFormat, toFormat, x, y, Double.NaN);
    }

    public double[] convertCoordinate(String fromFormat, String toFormat, double x, double y, double z) throws GeoConversionException {
        try {
            return this.convertAndGetCoordinateArray(this.getTransform(fromFormat, toFormat), new Coordinate(x, y, z));
        }
        catch (Exception e) {
            log.error("Failed to execute coordinate conversion: " + e.getMessage());
            throw new GeoConversionException("Conversion of coordinate failed", e);
        }
    }

    public Set<String> getSupportedAuthorities() {
        return CRS.getSupportedAuthorities((boolean)false);
    }

    public Set<String> getSupportedAuthorityAliases() {
        return CRS.getSupportedAuthorities((boolean)true);
    }

    public Set<String> getSupportedCodesForAuthority(String authority) {
        return CRS.getSupportedCodes((String)authority);
    }

    private MathTransform getTransform(String fromFormat, String toFormat) throws FactoryException {
        return CRS.findMathTransform((CoordinateReferenceSystem)CRS.decode((String)fromFormat), (CoordinateReferenceSystem)CRS.decode((String)toFormat), (boolean)false);
    }

    private double[] convertAndGetCoordinateArray(MathTransform transform, Coordinate coordinate) throws TransformException {
        JTS.transform((Coordinate)coordinate, (Coordinate)coordinate, (MathTransform)transform);
        if (Double.isNaN(coordinate.getZ())) {
            return new double[]{coordinate.getX(), coordinate.getY()};
        }
        return new double[]{coordinate.getX(), coordinate.getY(), coordinate.getZ()};
    }

    private CommandArgumentsException addExceptionArgument(CommandArgumentsException ex, int index, String message) {
        if (ex == null) {
            ex = new CommandArgumentsException("convert", "Invalid arguments provided");
        }
        ex.addArgumentError(index, message);
        return ex;
    }
}

