/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.dai.dispatcher;

import de.unibamberg.minf.gtf.commands.BaseCommandDispatcher;
import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;
import de.unibamberg.minf.gtf.exceptions.DataTransformationException;
import de.unibamberg.minf.gtf.extensions.dai.commands.ChronontologyCommands;
import de.unibamberg.minf.gtf.extensions.dai.converter.ChronontologyConverter;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyDerived;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyItem;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResource;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResponse;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class ChronontologyCommandsDispatcher
extends BaseCommandDispatcher
implements CommandDispatcher {
    private ChronontologyCommands commands;

    public ChronontologyCommands getCommands() {
        return this.commands;
    }

    public void setCommands(ChronontologyCommands commands) {
        this.commands = commands;
    }

    public Object executeDirect(String command, Object[] args, ExecutionContext executionContext) throws CommandExecutionException {
        try {
            if (command.equals("QUERY")) {
                if (!this.ensureCollectionSize(args, 1, 2)) {
                    throw new CommandExecutionException("QUERY", "Argument count must be 1 or 2");
                }
                if (args[0] == null) {
                    return null;
                }
                if (args.length == 2) {
                    return this.commands.queryChronontology(this.ensureCollection(this.getAsSimpleValue(args[0])), Integer.parseInt(args[1].toString()));
                }
                return this.commands.queryChronontology(this.ensureCollection(this.getAsSimpleValue(args[0])));
            }
            if (command.equals("GET")) {
                if (!this.ensureCollectionSize(args, 1)) {
                    throw new CommandExecutionException("GET", "Argument count must be exactly 1");
                }
                if (args[0] == null) {
                    return null;
                }
                return this.commands.getChronontologyItem(this.getAsSimpleValue(args[0]).toString());
            }
        }
        catch (CommandExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandExecutionException(command, (Throwable)e);
        }
        throw new CommandExecutionException(command, "Unknown command specified");
    }

    public boolean supportsConversion(Class<?> c) {
        if (ChronontologyDerived.class.isAssignableFrom(c) || ChronontologyItem.class.isAssignableFrom(c) || ChronontologyResource.class.isAssignableFrom(c) || ChronontologyResponse.class.isAssignableFrom(c)) {
            return true;
        }
        return super.supportsConversion(c);
    }

    public <T> SyntaxTreeNode convert(T c) throws DataTransformationException {
        if (c instanceof ChronontologyDerived) {
            return ChronontologyConverter.convertChronontologyDerived((ChronontologyDerived)c, null);
        }
        if (c instanceof ChronontologyItem) {
            return ChronontologyConverter.convertChronontologyItem((ChronontologyItem)c, null);
        }
        if (c instanceof ChronontologyResponse) {
            return ChronontologyConverter.convertChronontologyResponse((ChronontologyResponse)c);
        }
        if (c instanceof ChronontologyResource) {
            return ChronontologyConverter.convertChronontologyResource((ChronontologyResource)c, null);
        }
        return super.convert(c);
    }
}

