/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.dai.converter;

import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerCoordinate;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerIdentifier;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerItem;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerLink;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerLocation;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerName;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerResponse;
import de.unibamberg.minf.gtf.model.converters.BaseConverter;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class GazetteerConverter
extends BaseConverter {
    public static SyntaxTreeNode convertGazetteerResponse(GazetteerResponse response) {
        NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Response", null);
        if (response.getResults() != null) {
            for (GazetteerItem item : response.getResults()) {
                GazetteerConverter.convertGazetteerItem(item, node);
            }
        }
        return node;
    }

    public static SyntaxTreeNode convertGazetteerItem(GazetteerItem item, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode childNode;
        NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Resource", parentNode);
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Id", (Object)item.getId());
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"GazId", (Object)item.getGazId());
        if (item.getParent() != null) {
            GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Parent", (Object)item.getParent());
        }
        if (item.getAncestors() != null) {
            childNode = new NonterminalSyntaxTreeNode("Ancestors", node);
            for (String ancestor : item.getAncestors()) {
                GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)childNode, (String)"Ancestor", (Object)ancestor);
            }
        }
        if (item.getPrefName() != null) {
            childNode = new NonterminalSyntaxTreeNode("PrefName", node);
            GazetteerConverter.convertGazetteerName(item.getPrefName(), childNode);
        }
        if (item.getNames() != null) {
            childNode = new NonterminalSyntaxTreeNode("Names", node);
            for (GazetteerName name : item.getNames()) {
                GazetteerConverter.convertGazetteerName(name, childNode);
            }
        }
        if (item.getPrefLocation() != null) {
            childNode = new NonterminalSyntaxTreeNode("PrefLocation", node);
            GazetteerConverter.convertGazetteerLocation(item.getPrefLocation(), childNode);
        }
        if (item.getLocations() != null) {
            childNode = new NonterminalSyntaxTreeNode("Locations", node);
            for (GazetteerLocation location : item.getLocations()) {
                GazetteerConverter.convertGazetteerLocation(location, childNode);
            }
        }
        if (item.getIdentifiers() != null) {
            childNode = new NonterminalSyntaxTreeNode("Identifiers", node);
            for (GazetteerIdentifier identifier : item.getIdentifiers()) {
                GazetteerConverter.convertGazetteerIdentifier(identifier, childNode);
            }
        }
        if (item.getLinks() != null) {
            childNode = new NonterminalSyntaxTreeNode("Links", node);
            for (GazetteerLink link : item.getLinks()) {
                GazetteerConverter.convertGazetteerLink(link, childNode);
            }
        }
        if (item.getProvenance() != null) {
            childNode = new NonterminalSyntaxTreeNode("Provenance", node);
            for (String provenance : item.getProvenance()) {
                GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)childNode, (String)"ProvenanceItem", (Object)provenance);
            }
        }
        return node;
    }

    public static SyntaxTreeNode convertGazetteerLocation(GazetteerLocation location, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Location", parentNode);
        if (location.getCoordinates() != null) {
            GazetteerConverter.convertGazetteerCoordinate(location.getCoordinates(), node);
        }
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Confidence", (Object)location.getConfidence());
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"PublicSite", (Object)location.isPublicSite());
        return node;
    }

    public static SyntaxTreeNode convertGazetteerLink(GazetteerLink link, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Link", parentNode);
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Object", (Object)link.getObject());
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Predicate", (Object)link.getPredicate());
        return node;
    }

    public static SyntaxTreeNode convertGazetteerCoordinate(GazetteerCoordinate coordinate, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Coordinate", parentNode);
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Latitude", (Object)coordinate.getLatitude());
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Longitude", (Object)coordinate.getLongitude());
        return node;
    }

    public static SyntaxTreeNode convertGazetteerName(GazetteerName name, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Name", parentNode);
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Language", (Object)name.getLanguage());
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Title", (Object)name.getTitle());
        return node;
    }

    public static SyntaxTreeNode convertGazetteerIdentifier(GazetteerIdentifier identifier, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Identifier", parentNode);
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Context", (Object)identifier.getContext());
        GazetteerConverter.appendTerminalValue((NonterminalSyntaxTreeNode)node, (String)"Value", (Object)identifier.getValue());
        return node;
    }
}

