/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.dai.converter;

import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyDerived;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyItem;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResource;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResponse;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyTime;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyTimespan;
import de.unibamberg.minf.gtf.model.converters.BaseConverter;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import java.util.List;
import java.util.Map;

public class ChronontologyConverter
extends BaseConverter {
    public static SyntaxTreeNode convertChronontologyResponse(ChronontologyResponse response) {
        NonterminalSyntaxTreeNode responseNode = new NonterminalSyntaxTreeNode("Response", null);
        if (response.getResults() != null) {
            for (ChronontologyItem item : response.getResults()) {
                ChronontologyConverter.convertChronontologyItem(item, responseNode);
            }
        }
        return responseNode;
    }

    public static SyntaxTreeNode convertChronontologyItem(ChronontologyItem item) {
        return ChronontologyConverter.convertChronontologyItem(item, null);
    }

    public static SyntaxTreeNode convertChronontologyItem(ChronontologyItem item, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode itemNode = new NonterminalSyntaxTreeNode("Item", parentNode);
        ChronontologyConverter.convertChronontologyResource(item.getResource(), itemNode);
        ChronontologyConverter.convertChronontologyDerived(item.getDerived(), itemNode);
        return itemNode;
    }

    public static SyntaxTreeNode convertChronontologyResource(ChronontologyResource resource, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode resourceNode = new NonterminalSyntaxTreeNode("Resource", parentNode);
        ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)resourceNode, (String)"Id", (Object)resource.getId());
        ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)resourceNode, (String)"Type", (Object)resource.getType());
        ChronontologyConverter.appendRelations(resourceNode, "Relations", resource.getRelations());
        NonterminalSyntaxTreeNode namesNode = new NonterminalSyntaxTreeNode("Names", resourceNode);
        if (resource.getNames() != null) {
            for (String lang : resource.getNames().keySet()) {
                NonterminalSyntaxTreeNode localNamesNode = new NonterminalSyntaxTreeNode("Localized", namesNode);
                ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)localNamesNode, (String)"Language", (Object)lang);
                NonterminalSyntaxTreeNode localNameValues = new NonterminalSyntaxTreeNode("LocalizedNames", localNamesNode);
                if (resource.getNames().get(lang) == null) continue;
                for (String localName : resource.getNames().get(lang)) {
                    ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)localNameValues, (String)"LocalizedName", (Object)localName);
                }
            }
        }
        if (resource.getTimespans() != null) {
            for (ChronontologyTimespan ts : resource.getTimespans()) {
                ChronontologyConverter.convertChronontologyTimespan(ts, resourceNode);
            }
        }
        return resourceNode;
    }

    private static SyntaxTreeNode convertChronontologyTimespan(ChronontologyTimespan ts, NonterminalSyntaxTreeNode parentNode) {
        NonterminalSyntaxTreeNode timespanNode = new NonterminalSyntaxTreeNode("Timespan", parentNode);
        ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)timespanNode, (String)"TimeOriginal", (Object)ts.getTimeOriginal());
        ChronontologyConverter.convertChronontologyTime(ts.getBegin(), "Begin", timespanNode);
        ChronontologyConverter.convertChronontologyTime(ts.getEnd(), "End", timespanNode);
        return timespanNode;
    }

    private static SyntaxTreeNode convertChronontologyTime(ChronontologyTime time, String label, NonterminalSyntaxTreeNode parentNode) {
        if (time == null) {
            return null;
        }
        NonterminalSyntaxTreeNode timeNode = new NonterminalSyntaxTreeNode(label, parentNode);
        ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)timeNode, (String)"At", (Object)time.getAt());
        ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)timeNode, (String)"AtPrecision", (Object)time.getAtPrecision());
        return timeNode;
    }

    public static SyntaxTreeNode convertChronontologyDerived(ChronontologyDerived derived, NonterminalSyntaxTreeNode parentNode) {
        if (derived == null) {
            return null;
        }
        NonterminalSyntaxTreeNode derivedNode = new NonterminalSyntaxTreeNode("Derived", parentNode);
        ChronontologyConverter.appendRelations(derivedNode, "Relations", derived.getRelations());
        return derivedNode;
    }

    protected static void appendRelations(NonterminalSyntaxTreeNode resourceNode, String string, Map<String, List<String>> relations) {
        NonterminalSyntaxTreeNode relationsNode = new NonterminalSyntaxTreeNode("Relations", resourceNode);
        if (relations != null) {
            for (String relation : relations.keySet()) {
                NonterminalSyntaxTreeNode relationNode = new NonterminalSyntaxTreeNode(relation.substring(0, 1).toUpperCase() + relation.substring(1), relationsNode);
                if (relations.get(relation) == null) continue;
                for (String relationId : relations.get(relation)) {
                    ChronontologyConverter.appendTerminalValue((NonterminalSyntaxTreeNode)relationNode, (String)"Id", (Object)relationId);
                }
            }
        }
    }
}

