/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.dai.commands;

import de.unibamberg.minf.gtf.extensions.dai.commands.BaseDaiCommands;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerCoordinate;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerItem;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerLocation;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerResponse;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

public class GazetteerCommands
extends BaseDaiCommands {
    protected final Logger logger = LoggerFactory.getLogger(GazetteerCommands.class);
    private int defaultLimit;

    public int getDefaultLimit() {
        return this.defaultLimit;
    }

    public void setDefaultLimit(int defaultLimit) {
        this.defaultLimit = defaultLimit;
    }

    public GazetteerResponse queryGazetteer(String queryTerm, int topK) {
        if (queryTerm == null || queryTerm.trim().length() == 0) {
            return null;
        }
        try {
            StringBuilder urlBuilder = new StringBuilder().append(this.getBaseUrl()).append("search.json").append("?q=").append(UriUtils.encodeQueryParam((String)queryTerm, (String)"UTF-8")).append("&limit=").append(topK);
            return (GazetteerResponse)this.getRestTemplate().getForObject(new URI(urlBuilder.toString()), GazetteerResponse.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve valid iDAI Gazetteer response", (Throwable)e);
            return null;
        }
    }

    public GazetteerResponse queryGazetteer(String queryTerm) {
        return this.queryGazetteer(queryTerm, this.defaultLimit);
    }

    public GazetteerCoordinate queryGetTopCoordinates(String queryTerm) {
        GazetteerLocation result;
        if (queryTerm == null || queryTerm.trim().length() == 0) {
            return null;
        }
        GazetteerResponse resp = this.queryGazetteer(queryTerm, 1);
        if (resp == null || resp.getResults() == null || resp.getResults().size() == 0) {
            return null;
        }
        GazetteerItem item = resp.getResults().get(0);
        if (item.getPrefLocation() == null && item.getLocations() == null) {
            return null;
        }
        GazetteerLocation gazetteerLocation = result = item.getPrefLocation() != null ? item.getPrefLocation() : null;
        if (result != null) {
            return result.getCoordinates();
        }
        if (item.getLocations() != null) {
            for (GazetteerLocation loc : item.getLocations()) {
                if (result == null) {
                    result = loc;
                    continue;
                }
                if (loc.getCoordinates() == null || loc.getConfidence() <= result.getConfidence()) continue;
                result = loc;
            }
        }
        return result != null ? result.getCoordinates() : null;
    }

    public GazetteerItem getGazetteerItem(String id) {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        try {
            StringBuilder urlBuilder = new StringBuilder().append(this.getBaseUrl()).append("doc/").append(UriUtils.encodeQueryParam((String)id, (String)"UTF-8")).append(".json");
            return (GazetteerItem)this.getRestTemplate().getForObject(new URI(urlBuilder.toString()), GazetteerItem.class);
        }
        catch (Exception e) {
            this.logger.error("Failed to retrieve valid iDAI Gazetteer response", (Throwable)e);
            return null;
        }
    }
}

