package de.unibamberg.minf.gtf.extensions.dai.model.gazetteer;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class GazetteerItem {
	private String id;
	private int gazId;
	private String parent;
	private List<String> ancestors;
	private List<String> types;
	private GazetteerName prefName;
	private List<GazetteerName> names;
	private GazetteerLocation prefLocation;
	private List<GazetteerLocation> locations;
	private List<GazetteerIdentifier> identifiers;
	private List<GazetteerLink> links;
	private List<String> provenance;
	
	@JsonProperty(value="@id")
	public String getId() { return id; }
	public void setId(String id) { this.id = id;  }
	
	public int getGazId() { return gazId; }
	public void setGazId(int gazId) { this.gazId = gazId; }
	
	public String getParent() { return parent; }
	public void setParent(String parent) { this.parent = parent; }
	
	public List<String> getAncestors() { return ancestors; }
	public void setAncestors(List<String> ancestors) { this.ancestors = ancestors; }
	
	public List<String> getTypes() { return types; }
	public void setTypes(List<String> types) { this.types = types; }
	
	public GazetteerName getPrefName() { return prefName; }
	public void setPrefName(GazetteerName prefName) { this.prefName = prefName; }
	
	public List<GazetteerName> getNames() { return names; }
	public void setNames(List<GazetteerName> names) { this.names = names; }
	
	public GazetteerLocation getPrefLocation() { return prefLocation; }
	public void setPrefLocation(GazetteerLocation prefLocation) { this.prefLocation = prefLocation; }
	
	public List<GazetteerLocation> getLocations() { return locations; }
	public void setLocations(List<GazetteerLocation> locations) { this.locations = locations; }
	
	public List<GazetteerIdentifier> getIdentifiers() { return identifiers; }
	public void setIdentifiers(List<GazetteerIdentifier> identifiers) { this.identifiers = identifiers; }
	
	public List<GazetteerLink> getLinks() { return links; }
	public void setLinks(List<GazetteerLink> links) { this.links = links; }
	
	public List<String> getProvenance() { return provenance; }
	public void setProvenance(List<String> provenance) { this.provenance = provenance; }
	
	
	public GazetteerName findName(String language) {
		if (language==null || language.isEmpty() || this.getNames()==null || this.getPrefName()==null) {
			return null;
		}
		if (this.getPrefName()!=null && this.getPrefName().getLanguage().equals(language)) {
			return this.getPrefName();
		}
		if (this.getNames()!=null) {
			for (GazetteerName n : this.getNames()) {
				if (n.getLanguage().equals(language)) {
					return n;
				}
			}
		}
		return null;
	}	
}