package de.unibamberg.minf.gtf.extensions.dai.dispatcher;

import de.unibamberg.minf.gtf.commands.BaseCommandDispatcher;
import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;
import de.unibamberg.minf.gtf.exceptions.DataTransformationException;
import de.unibamberg.minf.gtf.extensions.dai.commands.GazetteerCommands;
import de.unibamberg.minf.gtf.extensions.dai.converter.GazetteerConverter;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerCoordinate;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerIdentifier;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerItem;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerLink;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerLocation;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerName;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerResponse;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class GazetteerCommandsDispatcher extends BaseCommandDispatcher implements CommandDispatcher {
	private GazetteerCommands commands;
	
	public GazetteerCommands getCommands() { return commands; }
	public void setCommands(GazetteerCommands commands) { this.commands = commands; }
	

	@Override
	public Object executeDirect(String command, Object[] args, ExecutionContext executionContext) throws CommandExecutionException {
		try {
			if (command.equals("QUERY")) {
				if (!ensureCollectionSize(args, 1, 2)) {
					throw new CommandExecutionException("QUERY", "Argument count must be 1 or 2");
				}
				if (args[0]==null) {
					return null;
				}
				if (args.length==2) {
					return commands.queryGazetteer(this.getAsSimpleValue(args[0]).toString(), Integer.parseInt(args[1].toString()));
				} else {
					return commands.queryGazetteer(this.getAsSimpleValue(args[0]).toString());
				}
			} else if (command.equals("GET")) {
				if (!ensureCollectionSize(args, 1)) {
					throw new CommandExecutionException("GET", "Argument count must be exactly 1");
				}
				if (args[0]==null) {
					return null;
				}
				return commands.getGazetteerItem(this.getAsSimpleValue(args[0]).toString());
			} else if (command.equals("TOPCOORD")) {
				if (!ensureCollectionSize(args, 1)) {
					throw new CommandExecutionException("QUERY", "Argument count must be exactly 1");
				}
				if (args[0]==null) {
					return null;
				}				
				return commands.queryGetTopCoordinates(this.getAsSimpleValue(args[0]).toString());
			}
		} catch (CommandExecutionException e) {
			throw e;
		} catch (Exception e) {
			throw new CommandExecutionException(command, e);
		}
		throw new CommandExecutionException(command, "Unknown command specified");
	}
	
	@Override
	public boolean supportsConversion(Class<?> c) {
		if (GazetteerResponse.class.isAssignableFrom(c) ||
				GazetteerItem.class.isAssignableFrom(c) || 
				GazetteerIdentifier.class.isAssignableFrom(c) ||
				GazetteerName.class.isAssignableFrom(c) ||
				GazetteerLocation.class.isAssignableFrom(c) ||
				GazetteerLink.class.isAssignableFrom(c) ||
				GazetteerCoordinate.class.isAssignableFrom(c)) {
			return true;
		}
		return super.supportsConversion(c);
	}
	
	@Override
	public <T> SyntaxTreeNode convert(T c) throws DataTransformationException {
		if (c instanceof GazetteerResponse) {
			return GazetteerConverter.convertGazetteerResponse((GazetteerResponse)c);
		} else if (c instanceof GazetteerItem) {
			return GazetteerConverter.convertGazetteerItem((GazetteerItem)c, null);
		} else if (c instanceof GazetteerIdentifier) {
			return GazetteerConverter.convertGazetteerIdentifier((GazetteerIdentifier)c, null);
		} else if (c instanceof GazetteerName) {
			return GazetteerConverter.convertGazetteerName((GazetteerName)c, null);
		} else if (c instanceof GazetteerLocation) {
			return GazetteerConverter.convertGazetteerLocation((GazetteerLocation)c, null);
		} else if (c instanceof GazetteerLink) {
			return GazetteerConverter.convertGazetteerLink((GazetteerLink)c, null);
		} else if (c instanceof GazetteerCoordinate) {
			return GazetteerConverter.convertGazetteerCoordinate((GazetteerCoordinate)c, null);
		}
		return super.convert(c);
	}
}
