package de.unibamberg.minf.gtf.extensions.dai.dispatcher;

import de.unibamberg.minf.gtf.commands.BaseCommandDispatcher;
import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;
import de.unibamberg.minf.gtf.exceptions.DataTransformationException;
import de.unibamberg.minf.gtf.extensions.dai.commands.ChronontologyCommands;
import de.unibamberg.minf.gtf.extensions.dai.converter.ChronontologyConverter;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyDerived;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyItem;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResource;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResponse;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class ChronontologyCommandsDispatcher extends BaseCommandDispatcher implements CommandDispatcher {
	
	private ChronontologyCommands commands;
	
	public ChronontologyCommands getCommands() { return commands; }
	public void setCommands(ChronontologyCommands commands) { this.commands = commands; }
	

	@Override
	public Object executeDirect(String command, Object[] args, ExecutionContext executionContext) throws CommandExecutionException {
		try {
			if (command.equals("QUERY")) {
				if (!ensureCollectionSize(args, 1, 2)) {
					throw new CommandExecutionException("QUERY", "Argument count must be 1 or 2");
				}
				if (args[0]==null) {
					return null;
				}
				if (args.length==2) {
					return commands.queryChronontology(this.ensureCollection(this.getAsSimpleValue(args[0])), Integer.parseInt(args[1].toString()));
				} else {
					return commands.queryChronontology(this.ensureCollection(this.getAsSimpleValue(args[0])));
				}
			} else if (command.equals("GET")) {
				if (!ensureCollectionSize(args, 1)) {
					throw new CommandExecutionException("GET", "Argument count must be exactly 1");
				}
				if (args[0]==null) {
					return null;
				}
				return commands.getChronontologyItem(this.getAsSimpleValue(args[0]).toString());
			}
		} catch (CommandExecutionException e) {
			throw e;
		} catch (Exception e) {
			throw new CommandExecutionException(command, e);
		}
		throw new CommandExecutionException(command, "Unknown command specified");
	}
	
	@Override
	public boolean supportsConversion(Class<?> c) {
		if (ChronontologyDerived.class.isAssignableFrom(c) ||
				ChronontologyItem.class.isAssignableFrom(c) || 
				ChronontologyResource.class.isAssignableFrom(c) ||
				ChronontologyResponse.class.isAssignableFrom(c)) {
			return true;
		}
		return super.supportsConversion(c);
	}
	
	@Override
	public <T> SyntaxTreeNode convert(T c) throws DataTransformationException {
		if (c instanceof ChronontologyDerived) {
			return ChronontologyConverter.convertChronontologyDerived((ChronontologyDerived)c, null);
		} else if (c instanceof ChronontologyItem) {
			return ChronontologyConverter.convertChronontologyItem((ChronontologyItem)c, null);
		} else if (c instanceof ChronontologyResponse) {
			return ChronontologyConverter.convertChronontologyResponse((ChronontologyResponse)c);
		} else if (c instanceof ChronontologyResource) {
			return ChronontologyConverter.convertChronontologyResource((ChronontologyResource)c, null);
		}
		return super.convert(c);
	}
}
