package de.unibamberg.minf.gtf.extensions.dai.converter;

import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerCoordinate;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerIdentifier;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerItem;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerLink;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerLocation;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerName;
import de.unibamberg.minf.gtf.extensions.dai.model.gazetteer.GazetteerResponse;
import de.unibamberg.minf.gtf.model.converters.BaseConverter;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class GazetteerConverter extends BaseConverter {
	
	public static SyntaxTreeNode convertGazetteerResponse(GazetteerResponse response) {
		NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Response", null);
		if (response.getResults()!=null) {
			for (GazetteerItem item : response.getResults()) {
				convertGazetteerItem(item, node);
			}
		} 
		return node;
	}
	
	public static SyntaxTreeNode convertGazetteerItem(GazetteerItem item, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Resource", parentNode);
		NonterminalSyntaxTreeNode childNode;
		
		appendTerminalValue(node, "Id", item.getId());
		appendTerminalValue(node, "GazId", item.getGazId());
		if (item.getParent()!=null) {
			appendTerminalValue(node, "Parent", item.getParent());
		}
		if (item.getAncestors()!=null) {
			childNode = new NonterminalSyntaxTreeNode("Ancestors", node);
			for (String ancestor : item.getAncestors()) {
				appendTerminalValue(childNode, "Ancestor", ancestor);
			}
		}
		if (item.getPrefName()!=null) {
			childNode = new NonterminalSyntaxTreeNode("PrefName", node);
			convertGazetteerName(item.getPrefName(), childNode);
		}
		if (item.getNames()!=null) {
			childNode = new NonterminalSyntaxTreeNode("Names", node);
			for (GazetteerName name : item.getNames()) {
				convertGazetteerName(name, childNode);
			}
		}
		if (item.getPrefLocation()!=null) {
			childNode = new NonterminalSyntaxTreeNode("PrefLocation", node);
			convertGazetteerLocation(item.getPrefLocation(), childNode);
		}
		if (item.getLocations()!=null) {
			childNode = new NonterminalSyntaxTreeNode("Locations", node);
			for (GazetteerLocation location : item.getLocations()) {
				convertGazetteerLocation(location, childNode);
			}
		}
		if (item.getIdentifiers()!=null) {
			childNode = new NonterminalSyntaxTreeNode("Identifiers", node);
			for (GazetteerIdentifier identifier : item.getIdentifiers()) {
				convertGazetteerIdentifier(identifier, childNode);
			}
		}
		if (item.getLinks()!=null) {
			childNode = new NonterminalSyntaxTreeNode("Links", node);
			for (GazetteerLink link : item.getLinks()) {
				convertGazetteerLink(link, childNode);
			}
		}
		if (item.getProvenance()!=null) {
			childNode = new NonterminalSyntaxTreeNode("Provenance", node);
			for (String provenance : item.getProvenance()) {
				appendTerminalValue(childNode, "ProvenanceItem", provenance);
			}
		}
		return node;
	}
	
	public static SyntaxTreeNode convertGazetteerLocation(GazetteerLocation location, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Location", parentNode);
		
		if (location.getCoordinates()!=null) {
			convertGazetteerCoordinate(location.getCoordinates(), node);
		}
		appendTerminalValue(node, "Confidence", location.getConfidence());
		appendTerminalValue(node, "PublicSite", location.isPublicSite());
		
		return node;
	}
	
	public static SyntaxTreeNode convertGazetteerLink(GazetteerLink link, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Link", parentNode);
	
		appendTerminalValue(node, "Object", link.getObject());
		appendTerminalValue(node, "Predicate", link.getPredicate());
		
		return node;
	}
	
	public static SyntaxTreeNode convertGazetteerCoordinate(GazetteerCoordinate coordinate, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Coordinate", parentNode);
		
		appendTerminalValue(node, "Latitude", coordinate.getLatitude());
		appendTerminalValue(node, "Longitude", coordinate.getLongitude());
		
		return node;
	}
	
	public static SyntaxTreeNode convertGazetteerName(GazetteerName name, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Name", parentNode);
		
		appendTerminalValue(node, "Language", name.getLanguage());
		appendTerminalValue(node, "Title", name.getTitle());
		
		return node;
	}
	
	public static SyntaxTreeNode convertGazetteerIdentifier(GazetteerIdentifier identifier, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode node = new NonterminalSyntaxTreeNode("Identifier", parentNode);
		
		appendTerminalValue(node, "Context", identifier.getContext());
		appendTerminalValue(node, "Value", identifier.getValue());
		
		return node;
	}
}
