package de.unibamberg.minf.gtf.extensions.dai.converter;

import java.util.List;
import java.util.Map;

import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyDerived;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyItem;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResource;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResponse;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyTime;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyTimespan;
import de.unibamberg.minf.gtf.model.converters.BaseConverter;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class ChronontologyConverter extends BaseConverter {
	
	public static SyntaxTreeNode convertChronontologyResponse(ChronontologyResponse response) {
		NonterminalSyntaxTreeNode responseNode = new NonterminalSyntaxTreeNode("Response", null);
		if (response.getResults()!=null) {
			for (ChronontologyItem item : response.getResults()) {
				convertChronontologyItem(item, responseNode);
			}
		} 
		return responseNode;
	}
	
	public static SyntaxTreeNode convertChronontologyItem(ChronontologyItem item) {
		return convertChronontologyItem(item, null);
	}
	
	
	public static SyntaxTreeNode convertChronontologyItem(ChronontologyItem item, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode itemNode = new NonterminalSyntaxTreeNode("Item", parentNode);
		convertChronontologyResource(item.getResource(), itemNode);
		convertChronontologyDerived(item.getDerived(), itemNode);
		
		return itemNode;
	}
	
	public static SyntaxTreeNode convertChronontologyResource(ChronontologyResource resource, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode resourceNode = new NonterminalSyntaxTreeNode("Resource", parentNode);
		
		appendTerminalValue(resourceNode, "Id", resource.getId());
		appendTerminalValue(resourceNode, "Type", resource.getType());
		
		appendRelations(resourceNode, "Relations", resource.getRelations());
		
		NonterminalSyntaxTreeNode namesNode = new NonterminalSyntaxTreeNode("Names", resourceNode);
		if (resource.getNames()!=null) {
			for (String lang : resource.getNames().keySet()) {
				NonterminalSyntaxTreeNode localNamesNode = new NonterminalSyntaxTreeNode("Localized", namesNode);
				appendTerminalValue(localNamesNode, "Language", lang);
				NonterminalSyntaxTreeNode localNameValues = new NonterminalSyntaxTreeNode("LocalizedNames", localNamesNode);
				if (resource.getNames().get(lang)!=null) {
					for (String localName : resource.getNames().get(lang)) {
						appendTerminalValue(localNameValues, "LocalizedName", localName);
					}
				}
			}
		}
		
		if (resource.getTimespans()!=null) {
			for (ChronontologyTimespan ts : resource.getTimespans()) {
				convertChronontologyTimespan(ts, resourceNode);
			}
		}
		
		return resourceNode;
	}

	private static SyntaxTreeNode convertChronontologyTimespan(ChronontologyTimespan ts, NonterminalSyntaxTreeNode parentNode) {
		NonterminalSyntaxTreeNode timespanNode = new NonterminalSyntaxTreeNode("Timespan", parentNode);
		appendTerminalValue(timespanNode, "TimeOriginal", ts.getTimeOriginal());
		
		convertChronontologyTime(ts.getBegin(), "Begin", timespanNode);
		convertChronontologyTime(ts.getEnd(), "End", timespanNode);
		
		return timespanNode;
	}

	private static SyntaxTreeNode convertChronontologyTime(ChronontologyTime time, String label, NonterminalSyntaxTreeNode parentNode) {
		if (time==null) {
			return null;
		}
		NonterminalSyntaxTreeNode timeNode = new NonterminalSyntaxTreeNode(label, parentNode);
		appendTerminalValue(timeNode, "At", time.getAt());
		appendTerminalValue(timeNode, "AtPrecision", time.getAtPrecision());
		
		return timeNode;
	}

	public static SyntaxTreeNode convertChronontologyDerived(ChronontologyDerived derived, NonterminalSyntaxTreeNode parentNode) {
		if (derived==null) {
			return null;
		}
		NonterminalSyntaxTreeNode derivedNode = new NonterminalSyntaxTreeNode("Derived", parentNode);
		
		appendRelations(derivedNode, "Relations", derived.getRelations());
		
		return derivedNode;
	}
	
	protected static void appendRelations(NonterminalSyntaxTreeNode resourceNode, String string, Map<String, List<String>> relations) {
		NonterminalSyntaxTreeNode relationsNode = new NonterminalSyntaxTreeNode("Relations", resourceNode);
		if (relations!=null) {
			for (String relation : relations.keySet()) {
				NonterminalSyntaxTreeNode relationNode = new NonterminalSyntaxTreeNode(relation.substring(0, 1).toUpperCase() + relation.substring(1), relationsNode);
				if (relations.get(relation)!=null) {
					for (String relationId : relations.get(relation)) {
						appendTerminalValue(relationNode, "Id", relationId);
					}
				}
			}
		}
	}
}
