package de.unibamberg.minf.gtf.extensions.dai.commands;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.UriUtils;

import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyItem;
import de.unibamberg.minf.gtf.extensions.dai.model.chronontology.ChronontologyResponse;

public class ChronontologyCommands extends BaseDaiCommands {
	protected final Logger logger = LoggerFactory.getLogger(ChronontologyCommands.class);
	
	public ChronontologyResponse queryChronontology(Collection<?> queryTerm, int topK) {
		if (queryTerm==null) {
			return null;
		}
		ChronontologyResponse resp = this.queryChronontology(queryTerm);
		if (resp.getResults()!=null && resp.getResults().size()>topK) {
			resp.setResults(resp.getResults().subList(0, topK));
		}
		return resp;
	}
	
	public ChronontologyResponse queryChronontology(Collection<?> collection) {
		try {
			ChronontologyResponse response = new ChronontologyResponse();
			ChronontologyResponse partResponse;
			
			for (Object o : collection) {
				if (o==null || o.toString().trim().length()==0) {
					continue;
				}
				StringBuilder urlBuilder = new StringBuilder()
						.append(this.getBaseUrl())
						.append("?q=").append(UriUtils.encodeQueryParam(o.toString(), "UTF-8"));
				
				
				partResponse = this.getRestTemplate().getForObject(new URI(urlBuilder.toString()), ChronontologyResponse.class);
			
				if (partResponse!=null && partResponse.getResults()!=null) {
					if (response.getResults()==null) {
						response.setResults(new ArrayList<ChronontologyItem>());
					}
					response.getResults().addAll(partResponse.getResults());
				}
			}
			if (response.getResults()==null) {
				return null;
			}
			return response;
			
		} catch (Exception e) {
			logger.error("Failed to retrieve valid DAI Chronontology response", e);
		}
		return null;
	}
	
	public ChronontologyItem getChronontologyItem(String id) {
		if (id==null || id.trim().length()==0) {
			return null;
		}
		try {
			StringBuilder urlBuilder = new StringBuilder()
					.append(this.getBaseUrl())
					.append(UriUtils.encodeQueryParam(id, "UTF-8"));
			
			
			return this.getRestTemplate().getForObject(new URI(urlBuilder.toString()), ChronontologyItem.class);
		} catch (Exception e) {
			logger.error("Failed to retrieve valid DAI Chronontology response", e);
		}
		return null;
	}
}
