/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

public class StringArrayToStringSerializer
extends StdSerializer<String[]> {
    private static final long serialVersionUID = -2830838383621329207L;

    protected StringArrayToStringSerializer(Class<String[]> t) {
        super(t);
    }

    protected StringArrayToStringSerializer() {
        super(String[].class);
    }

    public void serialize(String[] strings, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (strings == null || strings.length == 0) {
            gen.writeNull();
            return;
        }
        StringBuilder stringListBuilder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null || strings[i].isEmpty()) continue;
            if (stringListBuilder.length() > 0) {
                stringListBuilder.append(",");
            }
            stringListBuilder.append(strings[i]);
        }
        gen.writeString(stringListBuilder.toString());
    }
}

