/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.OsmId;
import java.io.IOException;

public class OsmIdArrayToStringSerializer
extends StdSerializer<OsmId[]> {
    private static final long serialVersionUID = -6931385692217943469L;

    protected OsmIdArrayToStringSerializer(Class<OsmId[]> t) {
        super(t);
    }

    protected OsmIdArrayToStringSerializer() {
        super(OsmId[].class);
    }

    public void serialize(OsmId[] osmIds, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (osmIds == null || osmIds.length == 0) {
            gen.writeNull();
            return;
        }
        StringBuilder idListBuilder = new StringBuilder();
        for (int i = 0; i < osmIds.length; ++i) {
            if (osmIds[i] == null || osmIds[i].getType() == null || osmIds[i].getType().isEmpty() || osmIds[i].getId() <= 0L) continue;
            if (idListBuilder.length() > 0) {
                idListBuilder.append(",");
            }
            idListBuilder.append(osmIds[i].getType().toUpperCase().charAt(0));
            idListBuilder.append(osmIds[i].getId());
        }
        gen.writeString(idListBuilder.toString());
    }
}

