/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo.request;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.BoundingBox;
import de.unibamberg.minf.gtf.extensions.clariah.geo.request.BaseRequestModel;
import de.unibamberg.minf.gtf.extensions.clariah.geo.serialization.StringArrayToStringSerializer;
import de.unibamberg.minf.gtf.extensions.clariah.geo.serialization.ViewboxToStringSerializer;
import java.util.Arrays;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Query
extends BaseRequestModel {
    @JsonProperty(value="q")
    private String expression;
    private String street;
    private String city;
    private String county;
    private String state;
    private String country;
    @JsonProperty(value="postalcode")
    private String postalCode;
    @JsonSerialize(using=StringArrayToStringSerializer.class)
    @JsonProperty(value="countrycodes")
    private String[] countryCodes;
    @JsonSerialize(using=StringArrayToStringSerializer.class)
    @JsonProperty(value="exclude_place_ids")
    private String[] excludePlaceIds;
    private Integer limit;
    @JsonSerialize(using=ViewboxToStringSerializer.class)
    @JsonProperty(value="viewbox")
    private BoundingBox viewBox;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Boolean bounded;
    @JsonProperty(value="polygon_threshold")
    private Float polygonThreshold;
    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    private Boolean dedupe;

    public String getExpression() {
        return this.expression;
    }

    public String getStreet() {
        return this.street;
    }

    public String getCity() {
        return this.city;
    }

    public String getCounty() {
        return this.county;
    }

    public String getState() {
        return this.state;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public String[] getCountryCodes() {
        return this.countryCodes;
    }

    public String[] getExcludePlaceIds() {
        return this.excludePlaceIds;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public BoundingBox getViewBox() {
        return this.viewBox;
    }

    public Boolean getBounded() {
        return this.bounded;
    }

    public Float getPolygonThreshold() {
        return this.polygonThreshold;
    }

    public Boolean getDedupe() {
        return this.dedupe;
    }

    @JsonProperty(value="q")
    public void setExpression(String expression) {
        this.expression = expression;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @JsonProperty(value="postalcode")
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    @JsonProperty(value="countrycodes")
    public void setCountryCodes(String[] countryCodes) {
        this.countryCodes = countryCodes;
    }

    @JsonProperty(value="exclude_place_ids")
    public void setExcludePlaceIds(String[] excludePlaceIds) {
        this.excludePlaceIds = excludePlaceIds;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    @JsonProperty(value="viewbox")
    public void setViewBox(BoundingBox viewBox) {
        this.viewBox = viewBox;
    }

    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    public void setBounded(Boolean bounded) {
        this.bounded = bounded;
    }

    @JsonProperty(value="polygon_threshold")
    public void setPolygonThreshold(Float polygonThreshold) {
        this.polygonThreshold = polygonThreshold;
    }

    @JsonFormat(shape=JsonFormat.Shape.NUMBER_INT)
    public void setDedupe(Boolean dedupe) {
        this.dedupe = dedupe;
    }

    public String toString() {
        return "Query(expression=" + this.getExpression() + ", street=" + this.getStreet() + ", city=" + this.getCity() + ", county=" + this.getCounty() + ", state=" + this.getState() + ", country=" + this.getCountry() + ", postalCode=" + this.getPostalCode() + ", countryCodes=" + Arrays.deepToString(this.getCountryCodes()) + ", excludePlaceIds=" + Arrays.deepToString(this.getExcludePlaceIds()) + ", limit=" + this.getLimit() + ", viewBox=" + this.getViewBox() + ", bounded=" + this.getBounded() + ", polygonThreshold=" + this.getPolygonThreshold() + ", dedupe=" + this.getDedupe() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Query)) {
            return false;
        }
        Query other = (Query)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Boolean this$bounded = this.getBounded();
        Boolean other$bounded = other.getBounded();
        if (this$bounded == null ? other$bounded != null : !((Object)this$bounded).equals(other$bounded)) {
            return false;
        }
        Float this$polygonThreshold = this.getPolygonThreshold();
        Float other$polygonThreshold = other.getPolygonThreshold();
        if (this$polygonThreshold == null ? other$polygonThreshold != null : !((Object)this$polygonThreshold).equals(other$polygonThreshold)) {
            return false;
        }
        Boolean this$dedupe = this.getDedupe();
        Boolean other$dedupe = other.getDedupe();
        if (this$dedupe == null ? other$dedupe != null : !((Object)this$dedupe).equals(other$dedupe)) {
            return false;
        }
        String this$expression = this.getExpression();
        String other$expression = other.getExpression();
        if (this$expression == null ? other$expression != null : !this$expression.equals(other$expression)) {
            return false;
        }
        String this$street = this.getStreet();
        String other$street = other.getStreet();
        if (this$street == null ? other$street != null : !this$street.equals(other$street)) {
            return false;
        }
        String this$city = this.getCity();
        String other$city = other.getCity();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$county = this.getCounty();
        String other$county = other.getCounty();
        if (this$county == null ? other$county != null : !this$county.equals(other$county)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        String this$postalCode = this.getPostalCode();
        String other$postalCode = other.getPostalCode();
        if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCountryCodes(), other.getCountryCodes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExcludePlaceIds(), other.getExcludePlaceIds())) {
            return false;
        }
        BoundingBox this$viewBox = this.getViewBox();
        BoundingBox other$viewBox = other.getViewBox();
        return !(this$viewBox == null ? other$viewBox != null : !((Object)this$viewBox).equals(other$viewBox));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Query;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Boolean $bounded = this.getBounded();
        result = result * 59 + ($bounded == null ? 43 : ((Object)$bounded).hashCode());
        Float $polygonThreshold = this.getPolygonThreshold();
        result = result * 59 + ($polygonThreshold == null ? 43 : ((Object)$polygonThreshold).hashCode());
        Boolean $dedupe = this.getDedupe();
        result = result * 59 + ($dedupe == null ? 43 : ((Object)$dedupe).hashCode());
        String $expression = this.getExpression();
        result = result * 59 + ($expression == null ? 43 : $expression.hashCode());
        String $street = this.getStreet();
        result = result * 59 + ($street == null ? 43 : $street.hashCode());
        String $city = this.getCity();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $county = this.getCounty();
        result = result * 59 + ($county == null ? 43 : $county.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        String $postalCode = this.getPostalCode();
        result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCountryCodes());
        result = result * 59 + Arrays.deepHashCode(this.getExcludePlaceIds());
        BoundingBox $viewBox = this.getViewBox();
        result = result * 59 + ($viewBox == null ? 43 : ((Object)$viewBox).hashCode());
        return result;
    }
}

