/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo.exception;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.unibamberg.minf.gtf.extensions.clariah.geo.exception.ServiceResponseErrorException;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.ServiceResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.ResponseErrorHandler;

public class NominatimResponseErrorHandler
implements ResponseErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(NominatimResponseErrorHandler.class);
    @Autowired
    private ObjectMapper objMapper = new ObjectMapper();

    public boolean hasError(ClientHttpResponse response) throws IOException {
        return response.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR || response.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        try {
            ServiceResponse resp = (ServiceResponse)this.objMapper.readValue(response.getBody(), ServiceResponse.class);
            if (resp != null && resp.getError() != null) {
                throw new ServiceResponseErrorException("Service returned error response", resp);
            }
        }
        catch (ServiceResponseErrorException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug("Serialization of error response to ServiceResponse.class failed: {}", (Object)e.getLocalizedMessage());
        }
        if (response.getStatusCode().series() == HttpStatus.Series.SERVER_ERROR) {
            throw new HttpServerErrorException(response.getStatusCode(), response.getStatusText());
        }
        if (response.getStatusCode().series() == HttpStatus.Series.CLIENT_ERROR) {
            throw new HttpClientErrorException(response.getStatusCode(), response.getStatusText());
        }
    }
}

