/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo.serialization;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.BoundingBox;
import java.io.IOException;

public class ViewboxToStringSerializer
extends StdSerializer<BoundingBox> {
    private static final long serialVersionUID = -23944397468330125L;

    protected ViewboxToStringSerializer(Class<BoundingBox> t) {
        super(t);
    }

    protected ViewboxToStringSerializer() {
        super(BoundingBox.class);
    }

    public void serialize(BoundingBox box, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (box == null || box.getNorthEastLatitude() == null && box.getNorthEastLongitude() == null && box.getSouthWestLatitude() == null && box.getSouthWestLongitude() == null) {
            gen.writeNull();
            return;
        }
        StringBuilder viewboxBuilder = new StringBuilder();
        if (box.getNorthEastLongitude() != null) {
            viewboxBuilder.append(box.getNorthEastLongitude());
        }
        viewboxBuilder.append(",");
        if (box.getNorthEastLatitude() != null) {
            viewboxBuilder.append(box.getNorthEastLatitude());
        }
        viewboxBuilder.append(",");
        if (box.getSouthWestLongitude() != null) {
            viewboxBuilder.append(box.getSouthWestLongitude());
        }
        viewboxBuilder.append(",");
        if (box.getSouthWestLatitude() != null) {
            viewboxBuilder.append(box.getSouthWestLatitude());
        }
        gen.writeString(viewboxBuilder.toString());
    }
}

