/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.unibamberg.minf.gtf.extensions.clariah.geo.exception.GeoParseException;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.BoundingBox;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.GeoCoordinate;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.GeoFeature;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.GeoShape;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.Geometry;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.OsmId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoFeatureGeoJsonDeserializer
extends StdDeserializer<GeoFeature> {
    private static final Logger log = LoggerFactory.getLogger(GeoFeatureGeoJsonDeserializer.class);
    private static final long serialVersionUID = -8694964170978799144L;
    private ObjectMapper objMapper = new ObjectMapper();

    public GeoFeatureGeoJsonDeserializer() {
        super(GeoFeature.class);
    }

    public GeoFeatureGeoJsonDeserializer(Class<?> vc) {
        super(vc);
    }

    public GeoFeature deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        GeoFeature f = new GeoFeature();
        f.setType(this.getStringValue(node, "type"));
        JsonNode detailsNode = node.get("properties");
        if (detailsNode != null && !detailsNode.isMissingNode()) {
            f.setOsm(new OsmId());
            f.getOsm().setId(this.getLongValue(detailsNode, "osm_id"));
            f.getOsm().setType(this.getStringValue(detailsNode, "osm_type"));
            f.setId(this.getLongValue(detailsNode, "place_id"));
            f.setDisplayName(this.getStringValue(detailsNode, "display_name"));
            f.setPlaceRank(this.getIntValue(detailsNode, "place_rank"));
            f.setCategory(this.getStringValue(detailsNode, "category"));
            f.setFeatureType(this.getStringValue(detailsNode, "type"));
            f.setImportance(this.getFloatValue(detailsNode, "importance"));
            f.setIcon(this.getStringValue(detailsNode, "icon"));
            f.setAddressDetails(this.getFieldMap(detailsNode.get("address")));
            f.setExtraTags(this.getFieldMap(detailsNode.get("extratags")));
            f.setNameDetails(this.getFieldMap(detailsNode.get("namedetails")));
        }
        try {
            f.setBoundingBox(this.getBoundingBox(node.get("bbox")));
        }
        catch (GeoParseException e) {
            log.warn("Failed to parse feature bounding box", (Throwable)e);
        }
        try {
            detailsNode = node.get("geometry");
            if (detailsNode != null && !detailsNode.isMissingNode()) {
                f.setGeometry(new Geometry());
                f.getGeometry().setType(this.getStringValue(detailsNode, "type"));
                f.getGeometry().setShapes(this.getGeoshapes(detailsNode.get("coordinates")).toArray(new GeoShape[0]));
            }
        }
        catch (GeoParseException e) {
            log.warn("Failed to parse feature geometry", (Throwable)e);
        }
        log.debug(this.objMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)f));
        return f;
    }

    private BoundingBox getBoundingBox(JsonNode node) throws GeoParseException {
        BoundingBox result = null;
        if (node != null) {
            if (node.isArray() && node.size() == 4) {
                ArrayNode array = (ArrayNode)node;
                result = new BoundingBox();
                result.setNorthEastLongitude(Float.valueOf((float)array.get(0).doubleValue()));
                result.setNorthEastLatitude(Float.valueOf((float)array.get(1).doubleValue()));
                result.setSouthWestLongitude(Float.valueOf((float)array.get(2).doubleValue()));
                result.setSouthWestLatitude(Float.valueOf((float)array.get(3).doubleValue()));
            } else {
                throw new GeoParseException(String.format("Bounding box error: expected 4 float values as bounding box; got: %s", node.toString()));
            }
        }
        return result;
    }

    private List<GeoShape> getGeoshapes(JsonNode node) throws GeoParseException {
        ArrayList<GeoShape> shapes = new ArrayList<GeoShape>();
        if (node != null && node.isArray() && node.size() > 0) {
            ArrayNode array = (ArrayNode)node;
            if (this.isCoordinateNode((JsonNode)array)) {
                shapes.add(new GeoShape(this.getCoordinate((JsonNode)array)));
            } else if (array.get(0).isArray() && array.get(0).size() > 0) {
                if (this.isCoordinateNode(array.get(0))) {
                    GeoCoordinate[] coordinates = new GeoCoordinate[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        coordinates[i] = this.getCoordinate(array.get(i));
                    }
                    shapes.add(new GeoShape(coordinates));
                } else {
                    for (int i = 0; i < array.size(); ++i) {
                        shapes.addAll(this.getGeoshapes(array.get(i)));
                    }
                }
            }
        }
        return shapes;
    }

    private boolean isCoordinateNode(JsonNode node) {
        return node.isArray() && (node.size() == 2 || node.size() == 3) && node.get(0).isFloatingPointNumber();
    }

    private GeoCoordinate getCoordinate(JsonNode array) {
        GeoCoordinate coord = new GeoCoordinate();
        coord.setLongitude((float)array.get(0).doubleValue());
        coord.setLatitude((float)array.get(1).doubleValue());
        return coord;
    }

    private Map<String, String> getFieldMap(JsonNode node) {
        if (node != null && !node.isMissingNode()) {
            Iterator fieldNameIterator = node.fieldNames();
            HashMap<String, String> fieldMap = new HashMap<String, String>();
            while (fieldNameIterator.hasNext()) {
                String fieldName = (String)fieldNameIterator.next();
                fieldMap.put(fieldName, this.getStringValue(node, fieldName));
            }
            return fieldMap;
        }
        return null;
    }

    private String getStringValue(JsonNode node, String fieldName) {
        JsonNode field = node.get(fieldName);
        if (field != null && !field.isMissingNode()) {
            return field.asText();
        }
        return null;
    }

    private long getLongValue(JsonNode node, String fieldName) {
        JsonNode field = node.get(fieldName);
        if (field != null && !field.isMissingNode()) {
            return field.asLong();
        }
        return 0L;
    }

    private int getIntValue(JsonNode node, String fieldName) {
        JsonNode field = node.get(fieldName);
        if (field != null && !field.isMissingNode()) {
            return field.asInt();
        }
        return 0;
    }

    private float getFloatValue(JsonNode node, String fieldName) {
        JsonNode field = node.get(fieldName);
        if (field != null && !field.isMissingNode()) {
            return (float)field.asDouble();
        }
        return 0.0f;
    }
}

