/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo;

import de.unibamberg.minf.gtf.extensions.clariah.geo.BaseNominatimRequest;
import de.unibamberg.minf.gtf.extensions.clariah.geo.exception.IllegalParametersException;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.ServiceResponse;
import de.unibamberg.minf.gtf.extensions.clariah.geo.request.Reverse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NominatimReverse
extends BaseNominatimRequest {
    private static final Logger log = LoggerFactory.getLogger(NominatimReverse.class);

    public ServiceResponse performReverse(Reverse r) {
        boolean osmIdComplete;
        boolean coordsComplete = r.getLatitude() != null && r.getLongitude() != null;
        boolean bl = osmIdComplete = r.getOsmType() != null && r.getOsmId() != null && r.getOsmId() > 0L;
        if (coordsComplete && osmIdComplete) {
            log.warn("Coordinates and osm id are set as reverse query parameters, which is illegal; respecting only coordinates");
            r.setOsmType(null);
            r.setOsmId(null);
        } else if (!coordsComplete && !osmIdComplete) {
            log.warn("Neither coordinates and osm id are set as reverse query parameters");
            this.getFailedServiceResponse(-1, new IllegalParametersException("Either coordinates or osmid must be provided as parameters", "latitude", "longitude", "osmType", "osmid"));
        } else if (coordsComplete) {
            r.setOsmType(null);
            r.setOsmId(null);
        } else {
            r.setLatitude(null);
            r.setLongitude(null);
        }
        String url = NominatimReverse.renderGetUrlWithParams(this.getBaseUrl() + "/reverse", r);
        return this.getResponse(url, this.setAcceptAllHeader(r));
    }
}

