/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.extensions.clariah.geo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.unibamberg.minf.gtf.extensions.clariah.geo.exception.ServiceResponseErrorException;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.ErrorResponse;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.GeoFeature;
import de.unibamberg.minf.gtf.extensions.clariah.geo.model.ServiceResponse;
import de.unibamberg.minf.gtf.extensions.clariah.geo.request.BaseRequestModel;
import de.unibamberg.minf.gtf.extensions.clariah.geo.serialization.GeoFeatureGeoJsonDeserializer;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedRuntimeException;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class BaseNominatimRequest {
    private static final Logger log = LoggerFactory.getLogger(BaseNominatimRequest.class);
    private static ObjectMapper objMapper = null;
    private String baseUrl;
    private RestTemplate restTemplate;
    private boolean preventAcceptHeader;

    public static ObjectMapper getObjMapper() {
        if (objMapper == null) {
            objMapper = new ObjectMapper();
            SimpleModule module = new SimpleModule();
            module.addDeserializer(GeoFeature.class, (JsonDeserializer)new GeoFeatureGeoJsonDeserializer());
            objMapper.registerModule((Module)module);
        }
        return objMapper;
    }

    public static String renderGetUrlWithParams(String url, Object requestObject) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        if (requestObject != null) {
            for (Map.Entry param : ((Map)BaseNominatimRequest.getObjMapper().convertValue(requestObject, (TypeReference)new TypeReference<Map<String, Object>>(){})).entrySet()) {
                if (param.getValue() == null || param.getValue().toString().isEmpty()) continue;
                builder.queryParam((String)param.getKey(), new Object[]{param.getValue()});
            }
        }
        return builder.toUriString();
    }

    protected <T extends BaseRequestModel> HttpEntity<T> setAcceptAllHeader(T requestBody) {
        if (this.isPreventAcceptHeader()) {
            LinkedMultiValueMap headers = new LinkedMultiValueMap();
            headers.add((Object)"Accept", (Object)"*/*");
            return new HttpEntity(requestBody, (MultiValueMap)headers);
        }
        return new HttpEntity(requestBody);
    }

    protected ServiceResponse getResponse(String url, HttpEntity<?> request) {
        ServiceResponse result;
        block8: {
            result = null;
            try {
                ResponseEntity response = this.getRestTemplate().exchange(new URI(url), HttpMethod.GET, request, String.class);
                if (response.getStatusCode().equals((Object)HttpStatus.OK)) {
                    log.debug("Nominatim request returned 200 OK ({})", (Object)url);
                    result = this.getSuccessfulServiceResponse((ResponseEntity<String>)response);
                } else {
                    log.warn("Nominatim request returned {} ({})", (Object)response.getStatusCode(), (Object)url);
                    result = this.getFailedServiceResponse(response.getStatusCodeValue(), null);
                }
            }
            catch (Exception e) {
                NestedRuntimeException ne;
                log.error("Nominatim request failed", (Throwable)e);
                int statusCode = -1;
                if (NestedRuntimeException.class.isAssignableFrom(e.getClass()) && ServiceResponseErrorException.class.isAssignableFrom((ne = (NestedRuntimeException)e).getMostSpecificCause().getClass())) {
                    result = ((ServiceResponseErrorException)ne.getMostSpecificCause()).getFailedResponse();
                }
                if (HttpClientErrorException.class.isAssignableFrom(e.getClass())) {
                    statusCode = ((HttpClientErrorException)e).getRawStatusCode();
                } else if (HttpServerErrorException.class.isAssignableFrom(e.getClass())) {
                    statusCode = ((HttpServerErrorException)e).getRawStatusCode();
                }
                if (result != null) break block8;
                result = this.getFailedServiceResponse(statusCode, e);
            }
        }
        return result;
    }

    protected ServiceResponse getSuccessfulServiceResponse(ResponseEntity<String> response) throws JsonProcessingException {
        ServiceResponse resp = (ServiceResponse)BaseNominatimRequest.getObjMapper().readValue((String)response.getBody(), ServiceResponse.class);
        if (resp.getError() == null) {
            resp.setSuccess(true);
        } else {
            log.warn("Nominatim request was answered with error message => {} ({})", (Object)(resp.getError().getMessage() == null ? "?" : resp.getError().getMessage()), resp.getError().getCode() == null ? "?" : resp.getError().getCode());
        }
        return resp;
    }

    protected ServiceResponse getFailedServiceResponse(int statusCode, Throwable e) {
        ServiceResponse result = new ServiceResponse();
        ErrorResponse error = new ErrorResponse();
        result.setError(error);
        error.setCode(statusCode);
        result.setType("error");
        result.setSuccess(false);
        if (e != null) {
            error.setMessage(String.format("%s => %s", e.getClass().getSimpleName(), e.getLocalizedMessage()));
        }
        return result;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public boolean isPreventAcceptHeader() {
        return this.preventAcceptHeader;
    }

    public void setPreventAcceptHeader(boolean preventAcceptHeader) {
        this.preventAcceptHeader = preventAcceptHeader;
    }
}

