/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.syntaxtree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;

public class TerminalSyntaxTreeNode
implements SyntaxTreeNode {
    private final String label;
    private NonterminalSyntaxTreeNode parentNode;

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public NonterminalSyntaxTreeNode getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(NonterminalSyntaxTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public TerminalSyntaxTreeNode(String label, NonterminalSyntaxTreeNode parentNode) {
        this.label = label;
        this.parentNode = parentNode;
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public String getPath() {
        if (this.parentNode != null && this.parentNode.getLabel() != "ROOT") {
            return String.format("%s.%s", this.parentNode.getPath(), this.label);
        }
        return this.label;
    }

    @Override
    public JsonNode getValue() {
        return new TextNode(this.label);
    }

    public String toString() {
        return "T: " + this.getText() + "\n";
    }

    @Override
    public String toString(int indent) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            s.append(" ");
        }
        s.append(this.toString());
        return s.toString();
    }
}

