/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.syntaxtree;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.TerminalSyntaxTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.tree.TerminalNode;

public class NonterminalSyntaxTreeNode
extends TerminalSyntaxTreeNode
implements SyntaxTreeNode {
    private static ObjectMapper objMapper = new ObjectMapper();
    private List<SyntaxTreeNode> children;
    private boolean isRoot;

    public List<SyntaxTreeNode> getChildren() {
        return this.children;
    }

    public void setChildren(List<SyntaxTreeNode> children) {
        this.children = children;
    }

    public NonterminalSyntaxTreeNode(String label, NonterminalSyntaxTreeNode parentNode) {
        super(label, parentNode);
        if (parentNode == null) {
            this.isRoot = true;
        } else {
            parentNode.addChildNode(this);
        }
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public void addChildNode(SyntaxTreeNode node) {
        if (this.children == null) {
            this.children = new ArrayList<SyntaxTreeNode>();
        }
        if (!this.children.contains(node)) {
            this.children.add(node);
        }
    }

    @Override
    public String getText() {
        return this.getText(false);
    }

    public String getText(boolean excludeNonterminalChildren) {
        if (this.children != null) {
            StringBuilder strBuilder = new StringBuilder();
            for (int i = 0; i < this.children.size(); ++i) {
                String childText;
                if (excludeNonterminalChildren && this.children.get(i) instanceof NonterminalSyntaxTreeNode || (childText = this.children.get(i).getText()) == null) continue;
                strBuilder.append(childText);
            }
            return strBuilder.toString();
        }
        return null;
    }

    @Override
    public JsonNode getValue() {
        if (this.children != null) {
            StringBuilder strBuilder = new StringBuilder();
            ObjectNode n = objMapper.createObjectNode();
            boolean hasNonterminalChildren = false;
            for (int i = 0; i < this.children.size(); ++i) {
                String childText;
                if (this.children.get(i) instanceof NonterminalSyntaxTreeNode) {
                    NonterminalSyntaxTreeNode nChild = (NonterminalSyntaxTreeNode)this.children.get(i);
                    n.set(nChild.getLabel(), nChild.getValue());
                    hasNonterminalChildren = true;
                    continue;
                }
                if (hasNonterminalChildren || (childText = this.children.get(i).getText()) == null) continue;
                strBuilder.append(childText);
            }
            if (hasNonterminalChildren) {
                return n;
            }
            return new TextNode(strBuilder.toString());
        }
        return null;
    }

    public boolean hasNonterminalChildren() {
        for (SyntaxTreeNode child : this.children) {
            if (!(child instanceof NonterminalSyntaxTreeNode)) continue;
            return true;
        }
        return false;
    }

    public List<NonterminalSyntaxTreeNode> getNodesForSelector(List<TerminalNode> scopedLabel) {
        return this.getNodesForSelector(this, scopedLabel, true);
    }

    public List<NonterminalSyntaxTreeNode> getNodesForSelectorList(List<List<TerminalNode>> scopedLabels) {
        return this.getNodesForSelectorList(this, scopedLabels);
    }

    private List<NonterminalSyntaxTreeNode> getNodesForSelector(NonterminalSyntaxTreeNode parent, List<TerminalNode> scopedLabel, boolean rootMatchRequired) {
        ArrayList<NonterminalSyntaxTreeNode> result = new ArrayList<NonterminalSyntaxTreeNode>();
        if (scopedLabel.size() == 0) {
            result.add(this);
            return result;
        }
        if (parent.children == null || parent.children.size() == 0) {
            return result;
        }
        for (SyntaxTreeNode node : parent.children) {
            if (!(node instanceof NonterminalSyntaxTreeNode)) continue;
            if (node.getLabel().equals(scopedLabel.get(0).getText())) {
                if (scopedLabel.size() == 1) {
                    result.add((NonterminalSyntaxTreeNode)node);
                    continue;
                }
                List<NonterminalSyntaxTreeNode> subResult = ((NonterminalSyntaxTreeNode)node).getNodesForSelector(scopedLabel.subList(1, scopedLabel.size()));
                if (subResult == null) continue;
                result.addAll(subResult);
                continue;
            }
            if (rootMatchRequired) continue;
            result.addAll(this.getNodesForSelector((NonterminalSyntaxTreeNode)node, scopedLabel, false));
        }
        return result;
    }

    private List<NonterminalSyntaxTreeNode> getNodesForSelectorList(NonterminalSyntaxTreeNode parent, List<List<TerminalNode>> scopedLabels) {
        if (parent.children == null || parent.children.isEmpty()) {
            return new ArrayList<NonterminalSyntaxTreeNode>(0);
        }
        if (scopedLabels.size() == 1) {
            return this.getNodesForSelector(scopedLabels.get(0));
        }
        ArrayList<NonterminalSyntaxTreeNode> result = new ArrayList<NonterminalSyntaxTreeNode>();
        for (SyntaxTreeNode node : parent.children) {
            boolean nodeAdded = false;
            ArrayList<List<TerminalNode>> subscopedLabels = new ArrayList<List<TerminalNode>>();
            for (List<TerminalNode> scopedLabel : scopedLabels) {
                if (!(node instanceof NonterminalSyntaxTreeNode) || !node.getLabel().equals(scopedLabel.get(0).getText())) continue;
                if (scopedLabel.size() == 1) {
                    result.add((NonterminalSyntaxTreeNode)node);
                    nodeAdded = true;
                    break;
                }
                subscopedLabels.add(scopedLabel.subList(1, scopedLabel.size()));
            }
            if (nodeAdded || subscopedLabels.isEmpty()) continue;
            result.addAll(((NonterminalSyntaxTreeNode)node).getNodesForSelectorList(subscopedLabels));
        }
        return result;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            s.append(" ");
        }
        s.append("N: ").append(this.getLabel()).append("\n");
        if (this.getChildren() != null) {
            for (SyntaxTreeNode childN : this.getChildren()) {
                s.append(childN.toString(indent + 2));
            }
        }
        return s.toString();
    }
}

