/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.model.entity.temporal;

import de.unibamberg.minf.gtf.model.entity.temporal.TemporalEntity;
import org.joda.time.DateTime;

public class EventEntityImpl
extends TemporalEntity {
    private TemporalEntity.PRECISION precision;
    private DateTime event;
    private String eventType;
    private Exception parseException;

    public DateTime getEvent() {
        return this.event;
    }

    public void setEvent(DateTime event) {
        this.event = event;
    }

    public TemporalEntity.PRECISION getPrecision() {
        return this.precision;
    }

    public void setPrecision(TemporalEntity.PRECISION precision) {
        this.precision = precision;
    }

    public Exception getParseException() {
        return this.parseException;
    }

    public boolean isError() {
        return this.parseException != null;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public void setCaption(String caption) {
        super.setCaption(caption);
        try {
            if (caption.length() == 2) {
                this.precision = TemporalEntity.PRECISION.CENTURY;
                this.event = new DateTime((long)Integer.parseInt(caption + "00"));
            } else if (caption.length() == 4) {
                this.precision = TemporalEntity.PRECISION.YEAR;
                this.event = PRECISION_YEAR_FORMATTER.parseDateTime(caption);
            } else if (caption.length() == 7) {
                String monthPart = caption.substring(5, 7);
                if (monthPart.equals("SP")) {
                    this.precision = TemporalEntity.PRECISION.SEASON;
                    this.event = PRECISION_MONTH_FORMATTER.parseDateTime(caption.substring(0, 5) + "03");
                } else if (monthPart.equals("SU")) {
                    this.precision = TemporalEntity.PRECISION.SEASON;
                    this.event = PRECISION_MONTH_FORMATTER.parseDateTime(caption.substring(0, 5) + "06");
                } else if (monthPart.equals("FA")) {
                    this.precision = TemporalEntity.PRECISION.SEASON;
                    this.event = PRECISION_MONTH_FORMATTER.parseDateTime(caption.substring(0, 5) + "09");
                } else if (monthPart.equals("WI")) {
                    this.precision = TemporalEntity.PRECISION.SEASON;
                    this.event = PRECISION_MONTH_FORMATTER.parseDateTime(caption.substring(0, 5) + "12");
                } else {
                    this.precision = TemporalEntity.PRECISION.MONTH;
                    this.event = PRECISION_MONTH_FORMATTER.parseDateTime(caption);
                }
            } else if (caption.length() == 10) {
                this.precision = TemporalEntity.PRECISION.DAY;
                this.event = PRECISION_DAY_FORMATTER.parseDateTime(caption);
            } else if (caption.length() == 13) {
                this.precision = TemporalEntity.PRECISION.HOUR;
                this.event = PRECISION_HOUR_FORMATTER.parseDateTime(caption);
            } else if (caption.length() == 16) {
                this.precision = TemporalEntity.PRECISION.MINUTE;
                this.event = PRECISION_MINUTE_FORMATTER.parseDateTime(caption);
            } else {
                this.precision = TemporalEntity.PRECISION.SECOND;
                this.event = PRECISION_SECOND_FORMATTER.parseDateTime(caption);
            }
        }
        catch (Exception e) {
            this.parseException = e;
        }
    }
}

