/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.exceptions;

import java.util.Arrays;

public class DataTransformationException
extends Exception {
    private static final long serialVersionUID = -38732153565365858L;
    private final Object[] arguments;

    public Object[] getArguments() {
        return this.arguments;
    }

    public DataTransformationException(String message) {
        super(message);
        this.arguments = null;
    }

    public DataTransformationException(String message, Throwable cause) {
        super(message, cause);
        this.arguments = null;
    }

    public DataTransformationException(String message, Throwable cause, Object[] arguments) {
        super(message, cause);
        this.arguments = arguments;
    }

    @Override
    public String toString() {
        Object errMessage = super.getLocalizedMessage();
        if (this.getCause() != null) {
            errMessage = (String)errMessage + "\n* Cause: " + this.getCause().getLocalizedMessage();
        }
        if (this.getArguments() != null && this.getArguments().length > 0) {
            errMessage = (String)errMessage + "\n* Arguments: " + Arrays.deepToString(this.getArguments());
        }
        return errMessage;
    }
}

