/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.commands;

import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.commands.Commands;
import de.unibamberg.minf.gtf.exceptions.DataTransformationException;
import de.unibamberg.minf.gtf.syntaxtree.NonterminalSyntaxTreeNode;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseCommands
implements Commands {
    public static final Set<Class<?>> SIMPLE_TYPES = BaseCommands.getSimpleTypes();

    @Override
    public Object getAsSimpleValue(Object arg, boolean skipSubordinate) {
        if (arg == null) {
            return null;
        }
        if (arg.toString().equals("null")) {
            return null;
        }
        if (arg instanceof NonterminalSyntaxTreeNode) {
            return ((NonterminalSyntaxTreeNode)arg).getText(skipSubordinate);
        }
        if (arg instanceof SyntaxTreeNode) {
            return ((SyntaxTreeNode)arg).getText();
        }
        if (this.isCollectionType(arg)) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object o : (Collection)arg) {
                result.add(this.getAsSimpleValue(o));
            }
            return result;
        }
        return arg;
    }

    @Override
    public Object getAsSimpleValue(Object arg) {
        return this.getAsSimpleValue(arg, true);
    }

    @Override
    public boolean isNullValue(Object arg) {
        if (arg == null) {
            return true;
        }
        String strArg = arg.toString();
        return strArg.isEmpty() || strArg.equalsIgnoreCase("null");
    }

    @Override
    public Class<?> getEnclosedType(Object arg) {
        if (arg == null) {
            return null;
        }
        if (this.isCollectionType(arg)) {
            Collection<?> c = this.ensureCollection(arg);
            if (!c.isEmpty()) {
                return c.iterator().next().getClass();
            }
            return null;
        }
        return arg.getClass();
    }

    @Override
    public boolean isCollectionType(Object arg) {
        if (arg instanceof Collection) {
            return true;
        }
        return arg.getClass().isArray();
    }

    @Override
    public <T> Collection<T> ensureCollection(Class<T> type, Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Collection) {
            ArrayList<T> tmpElements = new ArrayList<T>();
            for (Object a : (Collection)arg) {
                tmpElements.add(type.cast(a));
            }
            return tmpElements;
        }
        if (arg.getClass().isArray()) {
            int arraySize = Array.getLength(arg);
            ArrayList<T> tmpElements = new ArrayList<T>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                tmpElements.add(type.cast(Array.get(arg, i)));
            }
            return tmpElements;
        }
        ArrayList<T> tmpElements = new ArrayList<T>();
        tmpElements.add(type.cast(arg));
        return tmpElements;
    }

    @Override
    public Collection<?> ensureCollection(Object arg) {
        if (arg == null) {
            return null;
        }
        if (arg instanceof Collection) {
            return (Collection)arg;
        }
        if (arg.getClass().isArray()) {
            int arraySize = Array.getLength(arg);
            ArrayList<Object> tmpElements = new ArrayList<Object>(arraySize);
            for (int i = 0; i < arraySize; ++i) {
                tmpElements.add(Array.get(arg, i));
            }
            return tmpElements;
        }
        ArrayList<Object> tmpElements = new ArrayList<Object>();
        tmpElements.add(arg);
        return tmpElements;
    }

    @Override
    public List<Object> flattenArgs(Object[] args) {
        ArrayList<Object> c = new ArrayList<Object>();
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                Collection<?> cArg = this.ensureCollection(arg);
                if (cArg == null) continue;
                c.addAll(cArg);
            }
        }
        return c;
    }

    @Override
    public boolean ensureCollectionSize(Object arg, int size) {
        if (arg == null) {
            return size == 0;
        }
        Collection<?> collection = this.ensureCollection(arg);
        return collection.size() == size;
    }

    @Override
    public boolean ensureCollectionSize(Object arg, int minSize, int maxSize) {
        if (arg == null) {
            return minSize == 0;
        }
        Collection<?> collection = this.ensureCollection(arg);
        return collection.size() >= minSize && collection.size() <= maxSize;
    }

    @Override
    public boolean ensureCollectionSizeAtLeast(Object arg, int minSize) {
        if (arg == null) {
            return minSize == 0;
        }
        Collection<?> collection = this.ensureCollection(arg);
        return collection.size() >= minSize;
    }

    @Override
    public Map<String, CommandDispatcher> getSubordinateDispatchers() {
        return null;
    }

    @Override
    public boolean supportsConversion(Class<?> c) {
        return false;
    }

    @Override
    public <T> SyntaxTreeNode convert(T c) throws DataTransformationException {
        throw new DataTransformationException(String.format("Type conversion for [%s] not supported by this Command Dispatcher", c == null ? "null" : c.getClass().getName()));
    }

    @Override
    public final CommandDispatcher getConversionSupportingDispatcher(Class<?> c) {
        if (this.supportsConversion(c)) {
            return (CommandDispatcher)((Object)this);
        }
        Map<String, CommandDispatcher> subordinateDispatchers = this.getSubordinateDispatchers();
        if (subordinateDispatchers != null && subordinateDispatchers.size() > 0) {
            for (CommandDispatcher d : subordinateDispatchers.values()) {
                CommandDispatcher supportingDispatcher = d.getConversionSupportingDispatcher(c);
                if (supportingDispatcher == null) continue;
                return supportingDispatcher;
            }
        }
        return null;
    }

    @Override
    public final <T> SyntaxTreeNode convert(Collection<? extends T> c) throws DataTransformationException {
        NonterminalSyntaxTreeNode n = new NonterminalSyntaxTreeNode("ROOT", null);
        if (c != null && !c.isEmpty()) {
            for (T t : c) {
                if (t == null) continue;
                SyntaxTreeNode tn = this.convert(t);
                tn.setParentNode(n);
                n.addChildNode(tn);
            }
        }
        return n;
    }

    private static Set<Class<?>> getSimpleTypes() {
        HashSet ret = new HashSet();
        ret.add(Boolean.class);
        ret.add(Character.class);
        ret.add(Byte.class);
        ret.add(Short.class);
        ret.add(Integer.class);
        ret.add(Long.class);
        ret.add(Float.class);
        ret.add(Double.class);
        ret.add(Void.class);
        ret.add(String.class);
        ret.add(BigDecimal.class);
        return ret;
    }
}

