/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.gtf.commands;

import de.unibamberg.minf.gtf.commands.BaseCommands;
import de.unibamberg.minf.gtf.commands.CommandDispatcher;
import de.unibamberg.minf.gtf.context.ExecutionContext;
import de.unibamberg.minf.gtf.exceptions.CommandExecutionException;
import de.unibamberg.minf.gtf.exceptions.DataTransformationException;
import de.unibamberg.minf.gtf.syntaxtree.SyntaxTreeNode;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCommandDispatcher
extends BaseCommands
implements CommandDispatcher {
    @Override
    public final Object execute(String command, Object[] args, ExecutionContext exectionContext) throws CommandExecutionException {
        DispatcherWithLocalCommand dispatchableCommand = this.findExecutingDispatcher(command);
        if (dispatchableCommand != null) {
            if (dispatchableCommand.getDispatcher().getClass().equals(this.getClass())) {
                return this.executeDirect(command, args, exectionContext);
            }
            return dispatchableCommand.getDispatcher().execute(dispatchableCommand.getLocalCommand(), args, exectionContext);
        }
        throw new CommandExecutionException(command, "Could not resolve matching dispatcher for command");
    }

    @Override
    public final List<Boolean> supports(String command, Object[] args, ExecutionContext exectionContext) throws CommandExecutionException {
        DispatcherWithLocalCommand dispatchableCommand = this.findExecutingDispatcher(command);
        if (dispatchableCommand != null) {
            if (dispatchableCommand.getDispatcher().getClass().equals(this.getClass())) {
                return this.supportsDirect(dispatchableCommand.getLocalCommand(), args, exectionContext);
            }
            return dispatchableCommand.getDispatcher().supports(dispatchableCommand.getLocalCommand(), args, exectionContext);
        }
        throw new CommandExecutionException(command, "Could not resolve matching dispatcher for command");
    }

    @Override
    public List<Boolean> supportsDirect(String command, Object[] args, ExecutionContext exectionContext) throws CommandExecutionException {
        ArrayList<Boolean> result = new ArrayList<Boolean>();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Class<?> enclosedType = this.getEnclosedType(args[i]);
                if (enclosedType == null) {
                    result.add(new Boolean(true));
                    continue;
                }
                if (SIMPLE_TYPES.contains(enclosedType) || SyntaxTreeNode.class.isAssignableFrom(enclosedType)) {
                    result.add(new Boolean(true));
                    continue;
                }
                result.add(new Boolean(false));
            }
        }
        return result;
    }

    protected Object executeDirect(String command, Object[] args, ExecutionContext exectionContext) throws CommandExecutionException {
        throw new CommandExecutionException(command, "Command not implemented.");
    }

    protected DispatcherWithLocalCommand findExecutingDispatcher(String command) {
        if (this.getSubordinateDispatchers() == null || this.getSubordinateDispatchers().size() == 0) {
            return new DispatcherWithLocalCommand(this, command);
        }
        if ((command = command.trim().toUpperCase()).contains("::") || command.contains(".")) {
            String localCommand;
            String namespace;
            if (command.contains("::")) {
                namespace = command.substring(0, command.indexOf("::")).toString().toUpperCase();
                localCommand = command.substring(command.indexOf("::") + 2).toString().toUpperCase();
            } else {
                namespace = command.substring(0, command.indexOf(".")).toString().toUpperCase();
                localCommand = command.substring(command.indexOf(".") + 1).toString().toUpperCase();
            }
            if (this.getSubordinateDispatchers().containsKey(namespace)) {
                return new DispatcherWithLocalCommand(this.getSubordinateDispatchers().get(namespace), localCommand);
            }
        } else {
            return new DispatcherWithLocalCommand(this, command);
        }
        return null;
    }

    @Override
    public <T> SyntaxTreeNode convert(T c) throws DataTransformationException {
        if (this.getSubordinateDispatchers() != null) {
            for (CommandDispatcher subDispatcher : this.getSubordinateDispatchers().values()) {
                if (!subDispatcher.supportsConversion(c.getClass())) continue;
                return subDispatcher.convert(c);
            }
        }
        return super.convert(c);
    }

    @Override
    public boolean supportsConversion(Class<?> c) {
        if (this.getSubordinateDispatchers() != null) {
            for (CommandDispatcher subDispatcher : this.getSubordinateDispatchers().values()) {
                if (!subDispatcher.supportsConversion(c)) continue;
                return true;
            }
        }
        return super.supportsConversion(c);
    }

    protected class DispatcherWithLocalCommand {
        private final CommandDispatcher dispatcher;
        private final String localCommand;

        public CommandDispatcher getDispatcher() {
            return this.dispatcher;
        }

        public String getLocalCommand() {
            return this.localCommand;
        }

        public DispatcherWithLocalCommand(CommandDispatcher dispatcher, String localCommand) {
            this.dispatcher = dispatcher;
            this.localCommand = localCommand;
        }
    }
}

