var sessions;
$(document).ready(function() {
	sessions = new SessionHandler();
});

var SessionHandler = function() {
	__translator.addTranslations([
								"~de.unibamberg.minf.dme.dialog.confirm_delete_session.head",
								"~de.unibamberg.minf.dme.dialog.confirm_delete_session.body"
		]);
	//__translator.getTranslations();
	this.pathname = __util.getBaseUrl() + "sessions";
};

SessionHandler.prototype.newSession = function(entityId, callback) {
	var _this = this;
	$.ajax({
	    url: _this.pathname + "/async/newSession",
	    data: { entityId: entityId },
	    type: "GET",
	    success: function(data) {
	    	if (data.success) { 
	    		_this.handleCallback(callback, data);
	    	}
	    }, 
	    error: __util.processServerError
	});
};

SessionHandler.prototype.deleteSession = function(entityId, callback) {
	var _this = this;
	bootbox.confirm({
		title: __translator.translate("~de.unibamberg.minf.dme.dialog.confirm_delete_session.head"),
		message: __translator.translate("~de.unibamberg.minf.dme.dialog.confirm_delete_session.body"),
		callback: function(result) {
			if(result) {
				$.ajax({
				    url: _this.pathname + "/async/deleteSession",
				    data: { entityId: entityId },
				    type: "GET",
				    success: function(data) {
				    	if (data.success) { 
				    		_this.handleCallback(callback, data);
				    	}
				    }, 
				    error: __util.processServerError
				});
			}
		}
	});
};

SessionHandler.prototype.loadSession = function(entityId, callback) {
	if (!__util.isLoggedIn()) {
		__util.showLoginNote();
		return;
	}
	
	var _this = this;
	var form_identifier = "load-session-" + entityId;
	
	modalFormHandler = new ModalFormHandler({
		formFullUrl: _this.pathname + "/form/loadSession?entityId=" + entityId,
		identifier: form_identifier,
		//additionalModalClasses: "wide-modal",
		translations: [{placeholder: "~*servererror.head", key: "~de.unibamberg.minf.common.view.forms.servererror.head"},
		                {placeholder: "~*servererror.body", key: "~de.unibamberg.minf.common.view.forms.servererror.body"}
		                ],
		completeCallback: function() { window.location.reload(); }
	});
		
	modalFormHandler.show(form_identifier);
};

SessionHandler.prototype.saveSession = function(entityId, callback) {
	if (!__util.isLoggedIn()) {
		__util.showLoginNote();
		return;
	}
	
	var _this = this;
	var form_identifier = "save-session-" + entityId;
	
	modalFormHandler = new ModalFormHandler({
		formFullUrl: _this.pathname + "/form/saveSession?entityId=" + entityId,
		identifier: form_identifier,
		//additionalModalClasses: "wide-modal",
		translations: [{placeholder: "~*servererror.head", key: "~de.unibamberg.minf.common.view.forms.servererror.head"},
		                {placeholder: "~*servererror.body", key: "~de.unibamberg.minf.common.view.forms.servererror.body"}
		                ],
		//completeCallback: function() { window.location.reload(); }
	});
		
	modalFormHandler.show(form_identifier);
};

SessionHandler.prototype.handleCallback = function(callback, data) {
	if (callback != undefined && typeof callback == 'function') {
		callback(data);
	}	
};