var LogArea = function(config) {
	this.options = {
			entityId: "",
			maxLogEntries: 50,
			autoRefresh: 0,				// in ms; 0 to disable auto-refresh
			logList: $("ul#schema-editor-log"),
			pathPrefix : null				// must be set when used
	};
	$.extend(true, this.options, config);
	
	__translator.addTranslations([
		"~de.unibamberg.minf.common.label.warning",
		"~de.unibamberg.minf.common.label.error",
		"~de.unibamberg.minf.common.label.info",
		"~de.unibamberg.minf.common.label.success"
	]);
	__translator.getTranslations();
	
	this.tsMax = null;
	this.initLogging(); //
};

LogArea.prototype.initLogging = function() {
	if (this.options.pathPrefix===null || this.options.pathPrefix===undefined) {
		throw "pathPrefix setting must be provided in options";
	}
	this.refresh();
	this.autoRefresh();
};

LogArea.prototype.autoRefresh = function() {
	var _this = this;
	if (this.options.autoRefresh > 0) {
		setTimeout(function() { _this.refresh(); _this.autoRefresh(); }, _this.options.autoRefresh);
	};
};

LogArea.prototype.refresh = function() {
	var _this = this;
	$.ajax({
	    url: _this.options.pathPrefix + "async/getLog",
	    type: "GET",
	    data: { 
	    	maxEntries : _this.options.maxLogEntries,
	    	tsMin: _this.tsMax,
	    	entityId: _this.options.entityId
	    },
	    //dataType: "json",
	    success: function(data) {
	    	if (data!=null && data!=undefined && Array.isArray(data) && data.length>0) {
	    		_this.showLog(data);
	    	}
	    }, error: __util.processServerError
	});
};

LogArea.prototype.showLog = function(data) {
	if (this.tsMax!=null && data.length>0 && data[0].numericTimestamp<=this.tsMax) {
		return;
	}
	$(this.options.logList).html("");
	for (var i=0; i<data.length; i++) {
		if (i==0) {
			this.tsMax = data[i].numericTimestamp;
		} else if (i>=this.options.maxLogEntries-1) {
			break;
		}
		$(this.options.logList).append("<li class=\"log-" + data[i].logType + "\">" + data[i].timestamp + " <span class='log-type'>[" + __translator.translate("~de.unibamberg.minf.common.label." + data[i].logType.toLowerCase()) + "]</span> " + data[i].message + "</li>");
	}
};
