/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.sessions;

import de.unibamberg.minf.dme.service.interfaces.PersistedSessionService;
import de.unibamberg.minf.dme.sessions.SessionCleanerThread;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionCleanerService
implements InitializingBean,
DisposableBean {
    private static Logger logger = LoggerFactory.getLogger(SessionCleanerService.class);
    @Autowired
    private PersistedSessionService sessionService;
    private Timer timer = new Timer(true);
    private ExecutorService executorService = Executors.newFixedThreadPool(1);
    private int intervalMins;
    private int defaultExpirationMins;

    public int getIntervalMins() {
        return this.intervalMins;
    }

    public void setIntervalMins(int intervalMins) {
        this.intervalMins = intervalMins;
    }

    public int getDefaultExpirationMins() {
        return this.defaultExpirationMins;
    }

    public void setDefaultExpirationMins(int defaultExpirationMins) {
        this.defaultExpirationMins = defaultExpirationMins;
    }

    public void afterPropertiesSet() throws Exception {
        DateTime firstRun = DateTime.now().plusMinutes(this.intervalMins);
        logger.info(String.format("Scheduling SessionCleanerService every %s minutes; first run %s", this.intervalMins, firstRun));
        this.timer.scheduleAtFixedRate((TimerTask)new /* Unavailable Anonymous Inner Class!! */, firstRun.toDate(), (long)(this.intervalMins * 60000));
    }

    public void destroy() throws Exception {
        try {
            logger.info("Closing SessionCleanerService");
            this.executorService.shutdown();
            while (!this.executorService.isTerminated()) {
            }
        }
        catch (Exception e) {
            logger.error("Error closing SessionCleanerService", (Throwable)e);
        }
    }

    public synchronized void runSessionCleanerThread() {
        try {
            logger.info("Executing session cleaner as scheduled");
            SessionCleanerThread sessionCleanerThread = new SessionCleanerThread(this.sessionService, this.defaultExpirationMins);
            this.executorService.execute((Runnable)sessionCleanerThread);
        }
        catch (Exception e) {
            logger.error("An error occurred while executing schedule for synchronization with Collection Registry");
        }
    }
}

