/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service.base;

import de.unibamberg.minf.dme.dao.interfaces.ChangeSetDao;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import de.unibamberg.minf.dme.service.base.BaseService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseServiceImpl
implements BaseService {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ChangeSetDao changeSetDao;

    public static String getNormalizedName(String label) {
        return label.substring(0, 1).toUpperCase() + label.substring(1);
    }

    public List<ChangeSet> getChangeSetForEntity(String entityId) {
        return this.changeSetDao.findByEntityId(entityId);
    }

    public ChangeSet getLatestChangeSetForEntity(String id) {
        return this.changeSetDao.findLatestByEntityId(id);
    }

    public List<ChangeSet> getChangeSetForElement(String elementId) {
        return this.changeSetDao.findByElementId(elementId);
    }

    public List<ChangeSet> getChangeSetForEntities(List<String> entityIds) {
        return this.changeSetDao.findByEntityIds(entityIds);
    }

    public List<ChangeSet> getChangeSetForElements(List<String> elementIds) {
        return this.changeSetDao.findByElementIds(elementIds);
    }
}

