/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service.base;

import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.interfaces.ReferenceDao;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.ReferenceHelper;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.service.base.BaseReferenceService;
import de.unibamberg.minf.dme.service.base.BaseServiceImpl;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public abstract class BaseReferenceServiceImpl
extends BaseServiceImpl
implements BaseReferenceService {
    @Autowired
    protected ReferenceDao referenceDao;

    public void moveReference(String entityId, String elementId, Class<?> elementType, int delta, AuthPojo auth) {
        RootReference entityReference = (RootReference)this.referenceDao.findById(entityId);
        Assert.notNull((Object)entityReference);
        Reference parentReference = this.referenceDao.findParentByChildId((Reference)entityReference, elementId);
        Assert.notNull((Object)parentReference);
        List gRefs = (List)parentReference.getChildReferences().get(elementType.getName());
        for (int i = 0; i < gRefs.size(); ++i) {
            if (!((Reference)gRefs.get(i)).getReferenceId().equals(elementId)) continue;
            boolean change = false;
            if (i > 0 && delta == 2) {
                this.switchRefs(gRefs, i, 0);
                change = true;
            } else if (i < gRefs.size() - 1 && delta == -2) {
                this.switchRefs(gRefs, i, gRefs.size() - 1);
                change = true;
            } else if (i > 0 && delta == 1) {
                this.switchRefs(gRefs, i, i - 1);
                change = true;
            } else if (i < gRefs.size() - 1 && delta == -1) {
                this.switchRefs(gRefs, i, i + 1);
                change = true;
            }
            if (change) {
                parentReference.getChildReferences().put(elementType.getName(), gRefs);
                this.referenceDao.save((Identifiable)entityReference);
            }
            return;
        }
    }

    private void switchRefs(List<Reference> refs, int iFrom, int iTo) {
        Reference tRef = refs.get(iTo);
        refs.set(iTo, refs.get(iFrom));
        refs.set(iFrom, tRef);
    }

    protected RootReference findReferenceById(String schemaId) {
        return (RootReference)this.referenceDao.findById(schemaId);
    }

    protected void saveRootReference(RootReference reference) {
        this.referenceDao.save((Identifiable)reference);
    }

    protected static Reference addChildReference(Reference parentReference, Identifiable child) {
        Assert.notNull((Object)parentReference);
        Assert.isTrue((boolean)BaseDaoImpl.isValidObjectId((String)child.getId()), (String)"Element must be saved when reference is created.");
        Reference childReference = new Reference(child.getId());
        ReferenceHelper.addChildReference((Reference)parentReference, (Reference)childReference, (String)child.getClass().getName());
        return childReference;
    }

    protected void addChildReference(Reference parentReference, Reference childReference) {
        Identifiable child = this.referenceDao.findIdentifiableById(childReference.getReferenceId());
        if (child != null) {
            ReferenceHelper.addChildReference((Reference)parentReference, (Reference)childReference, (String)child.getClass().getName());
        }
    }

    protected void removeReference(String schemaId, String removeId, AuthPojo auth) throws IllegalArgumentException, ClassNotFoundException {
        RootReference entityReference = (RootReference)this.referenceDao.findById(schemaId);
        Assert.notNull((Object)entityReference);
        Reference removeReference = ReferenceHelper.removeSubreference((Reference)entityReference, (String)removeId);
        if (removeReference != null) {
            this.referenceDao.save((Identifiable)entityReference);
        }
    }

    protected void clearReferenceTree(String schemaId, AuthPojo auth) throws IllegalArgumentException, ClassNotFoundException {
        Reference rootReference = (Reference)this.referenceDao.findById(schemaId);
        if (rootReference == null) {
            return;
        }
        HashMap subordinateReferenceMap = new HashMap();
        ReferenceHelper.getAllSubordinateReferences((Reference)rootReference, subordinateReferenceMap);
    }
}

