/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service.base;

import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.interfaces.MappingDao;
import de.unibamberg.minf.dme.dao.interfaces.SchemaDao;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.service.base.BaseEntityService;
import de.unibamberg.minf.dme.service.base.BaseReferenceServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseEntityServiceImpl
extends BaseReferenceServiceImpl
implements BaseEntityService {
    @Autowired
    protected MappingDao mappingDao;
    @Autowired
    protected SchemaDao schemaDao;

    public boolean getUserCanWriteEntity(String entityId, String userId) {
        if (BaseDaoImpl.isNewId((String)entityId) && userId != null && !userId.isEmpty()) {
            return true;
        }
        return this.getUserCanWriteEntity(this.getRightsContainer(entityId, userId), userId);
    }

    public boolean getUserCanShareEntity(String entityId, String userId) {
        if (BaseDaoImpl.isNewId((String)entityId) && userId != null && !userId.isEmpty()) {
            return true;
        }
        return this.getUserCanShareEntity(this.getRightsContainer(entityId, userId), userId);
    }

    protected boolean getUserCanWriteEntity(RightsContainer<? extends TrackedEntity> container, String userId) {
        if (userId == null || container == null) {
            return false;
        }
        if (container.getOwnerId().equals(userId)) {
            return true;
        }
        if (container.isReadOnly()) {
            return false;
        }
        if (container.getWriteIds() == null) {
            return true;
        }
        return container.getWriteIds() != null && container.getWriteIds().contains(userId);
    }

    protected boolean getUserCanShareEntity(RightsContainer<? extends TrackedEntity> container, String userId) {
        if (userId == null || container == null) {
            return false;
        }
        if (container.getOwnerId().equals(userId)) {
            return true;
        }
        if (container.isReadOnly()) {
            return false;
        }
        if (container.getShareIds() == null) {
            return true;
        }
        return container.getShareIds() != null && container.getShareIds().contains(userId);
    }

    private RightsContainer<? extends TrackedEntity> getRightsContainer(String entityId, String userId) {
        if (this.schemaDao.findEnclosedById(entityId) != null) {
            return this.schemaDao.findByIdAndUserId(entityId, userId, true);
        }
        return this.mappingDao.findByIdAndUserId(entityId, userId, true);
    }
}

