/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.interfaces.UserDao;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.service.UserService;
import eu.dariah.de.dariahsp.model.User;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    @Autowired
    private UserDao userDetailsDao;

    public User loadUserByUsername(String domain, String username) throws UsernameNotFoundException {
        return this.userDetailsDao.findByUsername(domain, username);
    }

    public void saveUser(User persistedUser) {
        this.userDetailsDao.save((Identifiable)persistedUser);
    }

    public User findById(String id) {
        return (User)this.userDetailsDao.findById(id);
    }

    public List<String> getUsernames(String query) {
        ArrayList<String> usernames = new ArrayList<String>();
        int limit = 10;
        this.addIfListSizeSmaller(usernames, this.userDetailsDao.findByPropertyValue("username", (Object)query), limit);
        Query q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"username").regex("/^" + query + "/i"));
        q.limit(limit);
        this.addIfListSizeSmaller(usernames, this.userDetailsDao.findByQuery(q), limit);
        if (usernames.size() >= limit) {
            return usernames;
        }
        q = new Query();
        q.addCriteria((CriteriaDefinition)Criteria.where((String)"username").regex("/" + query + "/i"));
        q.limit(limit);
        this.addIfListSizeSmaller(usernames, this.userDetailsDao.findByQuery(q), limit);
        return usernames;
    }

    private void addIfListSizeSmaller(List<String> usernames, List<User> users, int limit) {
        for (User u : users) {
            if (usernames.size() < limit && !usernames.contains(u.getUsername())) {
                usernames.add(u.getUsername());
            }
            if (usernames.size() < limit) continue;
            return;
        }
    }
}

