/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.base.BaseDaoImpl;
import de.unibamberg.minf.dme.dao.interfaces.ElementDao;
import de.unibamberg.minf.dme.dao.interfaces.FunctionDao;
import de.unibamberg.minf.dme.dao.interfaces.GrammarDao;
import de.unibamberg.minf.dme.dao.interfaces.ReferenceDao;
import de.unibamberg.minf.dme.model.RightsContainer;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.base.Nonterminal;
import de.unibamberg.minf.dme.model.base.Terminal;
import de.unibamberg.minf.dme.model.datamodel.DatamodelImpl;
import de.unibamberg.minf.dme.model.datamodel.NonterminalImpl;
import de.unibamberg.minf.dme.model.datamodel.TerminalImpl;
import de.unibamberg.minf.dme.model.datamodel.base.Datamodel;
import de.unibamberg.minf.dme.model.datamodel.base.DatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.CsvDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.JsonDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.TextDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.XmlDatamodelNature;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlNamespace;
import de.unibamberg.minf.dme.model.datamodel.natures.xml.XmlTerminal;
import de.unibamberg.minf.dme.model.exception.MetamodelConsistencyException;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.model.tracking.ChangeSet;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.pojo.AuthWrappedPojo;
import de.unibamberg.minf.dme.service.ElementServiceImpl;
import de.unibamberg.minf.dme.service.base.BaseEntityServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.ElementService;
import de.unibamberg.minf.dme.service.interfaces.SchemaService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SchemaServiceImpl
extends BaseEntityServiceImpl
implements SchemaService {
    @Autowired
    private ElementService elementService;
    @Autowired
    private ElementDao elementDao;
    @Autowired
    private FunctionDao functionDao;
    @Autowired
    private GrammarDao grammarDao;
    @Autowired
    private ReferenceDao referenceDao;

    public List<Datamodel> findAllSchemas() {
        return this.schemaDao.findAllEnclosed();
    }

    public void saveSchema(AuthWrappedPojo<? extends Datamodel> schema, AuthPojo auth) {
        this.innerSaveSchema((Datamodel)schema.getPojo(), Boolean.valueOf(schema.isDraft()), Boolean.valueOf(schema.isReadOnly()), auth.getUserId(), auth.getSessionId());
    }

    public void saveSchema(Datamodel schema, AuthPojo auth) {
        this.innerSaveSchema(schema, null, null, auth.getUserId(), auth.getSessionId());
    }

    public void saveSchema(Datamodel schema, List<Reference> rootNonterminals, AuthPojo auth) {
        this.innerSaveSchema(schema, null, null, auth.getUserId(), auth.getSessionId());
        RootReference root = this.findReferenceById(schema.getId());
        if (root.getChildReferences() == null) {
            root.setChildReferences(new HashMap());
        }
        ArrayList<Reference> childArray = new ArrayList<Reference>(rootNonterminals.size());
        for (int i = 0; i < rootNonterminals.size(); ++i) {
            childArray.add(rootNonterminals.get(i));
        }
        root.getChildReferences().put(NonterminalImpl.class.getName(), childArray);
        this.saveRootReference(root);
    }

    private void innerSaveSchema(Datamodel schema, Boolean draft, Boolean readOnly, String userId, String sessionId) {
        RightsContainer container = null;
        boolean isNew = schema.getId() == null || schema.getId().equals("") || schema.getId().equals("undefined");
        container = isNew ? this.createContainer(userId) : (RightsContainer)this.schemaDao.findById(schema.getId());
        container.setElement((TrackedEntity)schema);
        if (draft != null) {
            container.setDraft(draft.booleanValue());
        }
        if (readOnly != null) {
            container.setReadOnly(readOnly.booleanValue());
        }
        this.schemaDao.save((TrackedEntity)container, userId, sessionId);
        if (isNew) {
            this.saveRootReference(new RootReference(container.getId()));
        }
    }

    private RightsContainer<Datamodel> createContainer(String userId) {
        RightsContainer container = new RightsContainer();
        container.setOwnerId(userId);
        container.setId(new ObjectId().toString());
        container.setDraft(true);
        return container;
    }

    public Datamodel findSchemaById(String id) {
        return (Datamodel)this.schemaDao.findEnclosedById(id);
    }

    public void deleteSchemaById(String id, AuthPojo auth) {
        RightsContainer s = (RightsContainer)this.schemaDao.findById(id);
        if (s != null && this.getUserCanWriteEntity(s, auth.getUserId())) {
            this.elementService.clearElementTree(id, auth);
            this.referenceDao.delete(id);
            this.schemaDao.delete((TrackedEntity)s, auth.getUserId(), auth.getSessionId());
        }
    }

    public Map<String, String> getAvailableTerminals(String schemaId) {
        HashMap<String, String> availableTerminals = new HashMap<String, String>();
        Datamodel s = this.findSchemaById(schemaId);
        XmlDatamodelNature sn = (XmlDatamodelNature)s.getNature(XmlDatamodelNature.class);
        if (sn != null && sn.getTerminals() != null) {
            for (XmlTerminal t : sn.getTerminals()) {
                availableTerminals.put(t.getId(), t.getName() + " (" + t.getNamespace() + ")");
            }
        }
        return availableTerminals;
    }

    public List<RightsContainer<Datamodel>> findAllByAuth(AuthPojo auth) {
        return this.schemaDao.findAllByUserId(auth.getUserId());
    }

    public RightsContainer<Datamodel> findByIdAndAuth(String schemaId, AuthPojo auth) {
        return this.schemaDao.findByIdAndUserId(schemaId, auth.getUserId());
    }

    public List<ChangeSet> getChangeSetForAllSchemas() {
        Query q = new Query();
        q.fields().include("_id");
        List schemas = this.schemaDao.find(q);
        ArrayList<String> ids = new ArrayList<String>();
        if (schemas != null) {
            for (RightsContainer s : schemas) {
                ids.add(s.getId());
            }
        }
        return super.getChangeSetForElements(ids);
    }

    public DatamodelImpl cloneSchemaForSubtree(Datamodel s, Element subtree) {
        DatamodelImpl expSchema = new DatamodelImpl();
        expSchema.setDescription(s.getDescription());
        expSchema.setId(s.getId());
        expSchema.setName(s.getId());
        List nonterminals = ElementServiceImpl.extractAllNonterminals((Element)subtree);
        try {
            for (DatamodelNature nature : s.getNatures()) {
                DatamodelNature expNature = (DatamodelNature)nature.clone();
                ArrayList<String> remNonterminalIds = new ArrayList<String>();
                for (String nId : nature.getNonterminalTerminalIdMap().keySet()) {
                    boolean remove = true;
                    for (Nonterminal n : nonterminals) {
                        if (!n.getId().equals(nId)) continue;
                        remove = false;
                        break;
                    }
                    if (!remove) continue;
                    remNonterminalIds.add(nId);
                }
                for (String rId : remNonterminalIds) {
                    expNature.removeNonterminalBinding(rId);
                }
                expSchema.addOrReplaceNature(expNature);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to clone schema nature", (Throwable)e);
        }
        return expSchema;
    }

    public boolean changeId(String currentId, String id) {
        RightsContainer dm = (RightsContainer)this.schemaDao.findById(currentId);
        dm.setId(id);
        this.schemaDao.save((Identifiable)dm);
        RootReference rootR = (RootReference)this.referenceDao.findById(currentId);
        rootR.setId(id);
        this.referenceDao.save((Identifiable)rootR);
        this.elementDao.updateEntityId(currentId, id);
        this.functionDao.updateEntityId(currentId, id);
        this.grammarDao.updateEntityId(currentId, id);
        this.schemaDao.delete(currentId);
        return true;
    }

    public void removeNature(String entityId, String natureClass, AuthPojo auth) {
        Datamodel m = this.findSchemaById(entityId);
        for (DatamodelNature n : m.getNatures()) {
            if (!n.getClass().getName().equals(natureClass)) continue;
            m.getNatures().remove(n);
            break;
        }
        this.saveSchema(m, auth);
    }

    public void addNature(String entityId, String natureClass, AuthPojo auth) {
        Datamodel m = this.findSchemaById(entityId);
        DatamodelNature n = this.createNature(natureClass);
        if (n != null && m.getNature(n.getClass()) == null) {
            m.addOrReplaceNature(n);
        }
        this.saveSchema(m, auth);
    }

    private DatamodelNature createNature(String natureClass) {
        if (natureClass == null) {
            return null;
        }
        if (XmlDatamodelNature.class.getName().equals(natureClass)) {
            return new XmlDatamodelNature();
        }
        if (JsonDatamodelNature.class.getName().equals(natureClass)) {
            return new JsonDatamodelNature();
        }
        if (CsvDatamodelNature.class.getName().equals(natureClass)) {
            return new CsvDatamodelNature();
        }
        if (TextDatamodelNature.class.getName().equals(natureClass)) {
            return new TextDatamodelNature();
        }
        this.logger.error("Failed to create DatamodelNature of type: " + natureClass);
        return null;
    }

    public List<Class<? extends DatamodelNature>> getMissingNatures(String entityId) {
        List classes = SchemaServiceImpl.getAllSuportedNatures();
        Datamodel m = this.findSchemaById(entityId);
        if (m == null) {
            return null;
        }
        if (m.getNatures() != null) {
            for (DatamodelNature n : m.getNatures()) {
                classes.remove(n.getClass());
            }
        }
        return classes;
    }

    public static List<Class<? extends DatamodelNature>> getAllSuportedNatures() {
        ArrayList<Class<? extends DatamodelNature>> classes = new ArrayList<Class<? extends DatamodelNature>>();
        classes.add(XmlDatamodelNature.class);
        classes.add(JsonDatamodelNature.class);
        classes.add(CsvDatamodelNature.class);
        classes.add(TextDatamodelNature.class);
        return classes;
    }

    public void updateNature(String entityId, XmlDatamodelNature xmlNature, AuthPojo auth) {
        Datamodel m = this.findSchemaById(entityId);
        XmlDatamodelNature existingXmlNature = (XmlDatamodelNature)m.getNature(XmlDatamodelNature.class);
        existingXmlNature.setRecordPath(xmlNature.getRecordPath());
        HashMap<String, String> urlPrefixMap = new HashMap<String, String>();
        ArrayList<String> removeNamespaces = new ArrayList<String>();
        if (existingXmlNature.getNamespaces() != null) {
            existingXmlNature.getNamespaces().removeAll(existingXmlNature.getNamespaces().stream().filter(ns -> ns.getUrl() == null).collect(Collectors.toList()));
            for (XmlNamespace existNs : existingXmlNature.getNamespaces()) {
                boolean remove = true;
                if (xmlNature.getNamespaces() != null) {
                    for (XmlNamespace updateNs : xmlNature.getNamespaces()) {
                        if (updateNs.getUrl().trim().isEmpty() || !existNs.getUrl().equals(updateNs.getUrl().trim())) continue;
                        urlPrefixMap.put(updateNs.getUrl().trim(), updateNs.getPrefix().trim());
                        remove = false;
                    }
                }
                if (!remove) continue;
                removeNamespaces.add(existNs.getUrl());
            }
        }
        for (XmlNamespace updateNs : xmlNature.getNamespaces()) {
            if (urlPrefixMap.containsKey(updateNs.getUrl().trim())) continue;
            urlPrefixMap.put(updateNs.getUrl().trim(), updateNs.getPrefix().trim());
        }
        if (existingXmlNature.getTerminals() != null) {
            for (XmlTerminal xmlTerminal : existingXmlNature.getTerminals()) {
                if (!removeNamespaces.contains(xmlTerminal.getNamespace())) continue;
                xmlTerminal.setNamespace("");
            }
        }
        existingXmlNature.setNamespaces(new ArrayList());
        for (String nsUrl : urlPrefixMap.keySet()) {
            if (nsUrl.isEmpty()) continue;
            existingXmlNature.getNamespaces().add(new XmlNamespace((String)urlPrefixMap.get(nsUrl), nsUrl));
        }
        this.saveSchema(m, auth);
    }

    public void createTerminals(String entityId, String natureClass, String namingOption, AuthPojo auth) throws ClassNotFoundException, MetamodelConsistencyException {
        Class<?> modelClazz = Class.forName(natureClass);
        Datamodel m = (Datamodel)this.findByIdAndAuth(entityId, auth).getElement();
        DatamodelNature n = m.getNature(modelClazz);
        List nonterminals = this.elementDao.find(new Query((CriteriaDefinition)Criteria.where((String)"entityId").is((Object)entityId).and("_class").is((Object)NonterminalImpl.class.getName())));
        for (Element e : nonterminals) {
            if (n.getTerminalId(e.getId()) != null) continue;
            XmlTerminal t = XmlDatamodelNature.class.isAssignableFrom(n.getClass()) ? new XmlTerminal() : new TerminalImpl();
            t.setId(BaseDaoImpl.createNewObjectId());
            if (namingOption.equals("unchanged")) {
                t.setName(e.getName());
            } else if (namingOption.equals("first_lower")) {
                t.setName(e.getName().substring(0, 1).toLowerCase() + e.getName().substring(1));
            } else if (namingOption.equals("all_upper")) {
                t.setName(e.getName().toUpperCase());
            } else if (namingOption.equals("all_lower")) {
                t.setName(e.getName().toLowerCase());
            }
            n.addTerminal((Terminal)t);
            n.mapNonterminal(e.getId(), t.getId());
        }
        this.saveSchema(m, auth);
    }
}

