/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.interfaces.ElementDao;
import de.unibamberg.minf.dme.dao.interfaces.FunctionDao;
import de.unibamberg.minf.dme.dao.interfaces.GrammarDao;
import de.unibamberg.minf.dme.dao.interfaces.ReferenceDao;
import de.unibamberg.minf.dme.dao.interfaces.RelatedConceptDao;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.model.base.Element;
import de.unibamberg.minf.dme.model.base.Function;
import de.unibamberg.minf.dme.model.base.Grammar;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.function.FunctionImpl;
import de.unibamberg.minf.dme.model.grammar.GrammarImpl;
import de.unibamberg.minf.dme.model.mapping.ExportedConceptImpl;
import de.unibamberg.minf.dme.model.mapping.MappedConceptImpl;
import de.unibamberg.minf.dme.model.mapping.base.MappedConcept;
import de.unibamberg.minf.dme.model.mapping.base.RelatedConcept;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.ReferenceHelper;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.model.tracking.TrackedEntity;
import de.unibamberg.minf.dme.pojo.RelatedConceptPojo;
import de.unibamberg.minf.dme.service.base.BaseReferenceServiceImpl;
import de.unibamberg.minf.dme.service.interfaces.RelatedConceptService;
import eu.dariah.de.dariahsp.web.model.AuthPojo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class RelatedConceptServiceImpl
extends BaseReferenceServiceImpl
implements RelatedConceptService {
    @Autowired
    private RelatedConceptDao mappedConceptDao;
    @Autowired
    private ElementDao elementDao;
    @Autowired
    private GrammarDao grammarDao;
    @Autowired
    private FunctionDao functionDao;
    @Autowired
    private ReferenceDao referenceDao;

    public void saveRelatedConcept(RelatedConcept relatedConcept, String mappingId, AuthPojo auth) {
        Reference refConcept;
        boolean isNew;
        relatedConcept.setEntityId(mappingId);
        this.mappedConceptDao.save((TrackedEntity)relatedConcept, auth.getUserId(), auth.getSessionId());
        RootReference root = this.findReferenceById(mappingId);
        boolean needReferenceSave = false;
        boolean bl = isNew = ReferenceHelper.findSubreference((Reference)root, (String)relatedConcept.getId()) == null;
        if (isNew) {
            refConcept = BaseReferenceServiceImpl.addChildReference((Reference)root, (Identifiable)relatedConcept);
            if (MappedConcept.class.isAssignableFrom(relatedConcept.getClass())) {
                Function function = null;
                MappedConcept mappedConcept = (MappedConcept)MappedConcept.class.cast(relatedConcept);
                if (mappedConcept.getFunctionId() != null) {
                    function = (Function)this.functionDao.findById(mappedConcept.getFunctionId());
                }
                if (function == null) {
                    function = new FunctionImpl(mappingId, "fMapping");
                    this.functionDao.save((TrackedEntity)function, auth.getUserId(), auth.getSessionId());
                    mappedConcept.setFunctionId(function.getId());
                }
                RelatedConceptServiceImpl.addChildReference((Reference)refConcept, function);
            }
            needReferenceSave = true;
        } else {
            refConcept = ReferenceHelper.findSubreference((Reference)root, (String)relatedConcept.getId());
        }
        for (String sourceElementId : relatedConcept.getElementGrammarIdsMap().keySet()) {
            Grammar grammar;
            if (relatedConcept.getElementGrammarIdsMap().get(sourceElementId) == null) {
                Element source = (Element)this.elementDao.findById(sourceElementId);
                grammar = new GrammarImpl(mappingId, source.getName());
                grammar.setPassthrough(true);
                this.grammarDao.save((TrackedEntity)grammar, auth.getUserId(), auth.getSessionId());
                relatedConcept.getElementGrammarIdsMap().put(sourceElementId, grammar.getId());
            } else {
                grammar = (Grammar)this.grammarDao.findById((String)relatedConcept.getElementGrammarIdsMap().get(sourceElementId));
            }
            RelatedConceptServiceImpl.addChildReference((Reference)refConcept, (Identifiable)grammar);
            needReferenceSave = true;
        }
        if (needReferenceSave) {
            this.saveRootReference(root);
            this.mappedConceptDao.save((TrackedEntity)relatedConcept, auth.getUserId(), auth.getSessionId());
        }
    }

    public List<RelatedConcept> findAllByMappingId(String mappingId) {
        return this.mappedConceptDao.findByEntityId(mappingId);
    }

    public List<RelatedConcept> findAllByMappingId(String mappingId, boolean eagerLoadHierarchy) {
        RootReference reference = this.findReferenceById(mappingId);
        if (reference.getChildReferences() == null || reference.getChildReferences().isEmpty()) {
            return new ArrayList<RelatedConcept>();
        }
        ArrayList<RelatedConcept> result = new ArrayList<RelatedConcept>();
        List elements = this.getAllElements(mappingId);
        HashMap<String, Identifiable> elementMap = new HashMap<String, Identifiable>(elements.size());
        for (Identifiable e : elements) {
            elementMap.put(e.getId(), e);
        }
        for (Reference r : reference.getChildReferences(new String[]{MappedConceptImpl.class.getName(), ExportedConceptImpl.class.getName()})) {
            Identifiable iTest = ReferenceHelper.fillElement((Reference)r, elementMap);
            if (iTest != null) {
                result.add((RelatedConcept)RelatedConcept.class.cast(iTest));
                continue;
            }
            this.logger.warn("Inconsistency warning: Mapping references concept that no longer exists");
        }
        return result;
    }

    public RelatedConcept findById(String id) {
        return (RelatedConcept)this.mappedConceptDao.findById(id);
    }

    public RelatedConcept findById(String mappingId, String mappedConceptId, boolean eagerLoadHierarchy) {
        RootReference reference = this.findReferenceById(mappingId);
        if (reference.getChildReferences() == null || reference.getChildReferences().isEmpty()) {
            return null;
        }
        ArrayList<String> grammarIds = new ArrayList<String>();
        ArrayList<String> functionIds = new ArrayList<String>();
        Reference r = null;
        for (Reference rConcept : reference.getChildReferences(new String[]{MappedConceptImpl.class.getName(), ExportedConceptImpl.class.getName()})) {
            if (!rConcept.getReferenceId().equals(mappedConceptId)) continue;
            r = rConcept;
            if (rConcept.getChildReferences() == null || !rConcept.getChildReferences().containsKey(GrammarImpl.class.getName())) break;
            for (Reference reference2 : (List)rConcept.getChildReferences().get(GrammarImpl.class.getName())) {
                grammarIds.add(reference2.getReferenceId());
                if (reference2.getChildReferences() == null || !reference2.getChildReferences().containsKey(FunctionImpl.class.getName())) continue;
                for (Reference rFunction : (List)reference2.getChildReferences().get(FunctionImpl.class.getName())) {
                    functionIds.add(rFunction.getReferenceId());
                }
            }
        }
        if (r == null) {
            return null;
        }
        ArrayList<TrackedEntity> elements = new ArrayList<TrackedEntity>();
        elements.add(this.mappedConceptDao.findById(mappedConceptId));
        elements.addAll(this.grammarDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(grammarIds))));
        elements.addAll(this.functionDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"_id").in(functionIds))));
        HashMap<String, Identifiable> elementMap = new HashMap<String, Identifiable>(elements.size());
        for (Identifiable identifiable : elements) {
            elementMap.put(identifiable.getId(), identifiable);
        }
        return (RelatedConcept)ReferenceHelper.fillElement((Reference)r, elementMap);
    }

    public void removeRelatedConcept(String mappingId, String conceptId, AuthPojo auth) throws GenericScheregException {
        RelatedConcept c = (RelatedConcept)this.mappedConceptDao.findById(conceptId);
        if (!c.getEntityId().equals(mappingId)) {
            throw new GenericScheregException("Attempted to delete related concept via wrong mapping");
        }
        try {
            this.removeReference(mappingId, conceptId, auth);
            this.mappedConceptDao.delete((TrackedEntity)c, auth.getUserId(), auth.getSessionId());
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            this.logger.error("Failed to remove related concept", (Throwable)e);
        }
    }

    public void removeSourceElementById(AuthPojo auth, String mappingId, RelatedConcept rc, String sourceId) {
        if (!rc.getElementGrammarIdsMap().containsKey(sourceId)) {
            return;
        }
        rc.getElementGrammarIdsMap().remove(sourceId);
        if (rc.getElementGrammarIdsMap().size() == 0) {
            try {
                this.removeRelatedConcept(mappingId, rc.getId(), auth);
            }
            catch (GenericScheregException e) {
                this.logger.error("Failed to remove empty related concept", (Throwable)e);
            }
        } else {
            this.saveRelatedConcept(rc, mappingId, auth);
            RootReference rMapping = this.findReferenceById(mappingId);
            ReferenceHelper.removeSubreference((Reference)rMapping, (String)sourceId);
            this.saveRootReference(rMapping);
        }
    }

    public void removeSourceElementById(AuthPojo auth, String mappingId, String conceptId, String sourceId) {
        this.removeSourceElementById(auth, mappingId, this.findById(conceptId), sourceId);
    }

    private List<Identifiable> getAllElements(String mappingId) {
        ArrayList<Identifiable> elements = new ArrayList<Identifiable>();
        elements.addAll(this.mappedConceptDao.findByEntityId(mappingId));
        elements.addAll(this.grammarDao.findByEntityId(mappingId));
        elements.addAll(this.functionDao.findByEntityId(mappingId));
        return elements;
    }

    public void removeElementReferences(String entityId, String elementId) {
        ArrayList<String> deleteConcepts = new ArrayList<String>();
        ArrayList<String> deleteGrammars = new ArrayList<String>();
        ArrayList<String> deleteFunctions = new ArrayList<String>();
        HashMap<String, RootReference> rootReferences = new HashMap<String, RootReference>();
        List concepts = this.mappedConceptDao.findBySourceElementId(elementId);
        concepts.addAll(this.mappedConceptDao.findByTargetElementId(elementId));
        for (RelatedConcept c : concepts) {
            RootReference currentRootReference;
            if (rootReferences.containsKey(c.getEntityId())) {
                currentRootReference = (RootReference)rootReferences.get(c.getEntityId());
            } else {
                currentRootReference = (RootReference)this.referenceDao.findById(c.getEntityId());
                rootReferences.put(c.getEntityId(), currentRootReference);
            }
            if (c.getElementGrammarIdsMap().containsKey(elementId)) {
                String removeGrammarId = (String)c.getElementGrammarIdsMap().remove(elementId);
                deleteGrammars.add(removeGrammarId);
                this.referenceDao.removeById((Reference)currentRootReference, removeGrammarId);
            } else if (c.getTargetElementIds().contains(elementId)) {
                c.getTargetElementIds().remove(elementId);
            }
            if (c.getTargetElementIds().isEmpty() || c.getElementGrammarIdsMap().isEmpty()) {
                if (MappedConcept.class.isAssignableFrom(c.getClass())) {
                    deleteFunctions.add(((MappedConcept)c).getFunctionId());
                }
                if (c.getElementGrammarIdsMap().size() > 0) {
                    for (String sourceId : c.getElementGrammarIdsMap().keySet()) {
                        deleteGrammars.add((String)c.getElementGrammarIdsMap().get(sourceId));
                    }
                }
                deleteConcepts.add(c.getId());
                this.referenceDao.removeById((Reference)currentRootReference, c.getId());
                continue;
            }
            this.mappedConceptDao.save((Identifiable)c);
        }
        for (RootReference root : rootReferences.values()) {
            this.referenceDao.save((Identifiable)root);
        }
        this.functionDao.delete(deleteFunctions);
        this.grammarDao.delete(deleteGrammars);
        this.mappedConceptDao.delete(deleteConcepts);
    }

    public RelatedConcept switchConceptType(String mappingId, String mappedConceptId, RelatedConceptPojo.MappingTypes mappingType, AuthPojo auth) {
        try {
            MappedConceptImpl rcReplace;
            RelatedConcept rcDel = this.findById(mappedConceptId);
            if (mappingType.equals((Object)RelatedConceptPojo.MappingTypes.EXPORT)) {
                ExportedConceptImpl ecReplace = new ExportedConceptImpl();
                ecReplace.setFormat(ExportedConceptImpl.ExportFormats.JSON);
                ecReplace.setIncludeTree(true);
                ecReplace.setIncludeSelf(true);
                ecReplace.setEscape(false);
                rcReplace = ecReplace;
            } else {
                rcReplace = new MappedConceptImpl();
            }
            rcReplace.setId(mappedConceptId);
            rcReplace.setTargetElementIds(new ArrayList(rcDel.getTargetElementIds()));
            rcReplace.setElementGrammarIdsMap(new HashMap<String, String>(rcDel.getElementGrammarIdsMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
            this.removeRelatedConcept(mappingId, mappedConceptId, auth);
            this.saveRelatedConcept((RelatedConcept)rcReplace, mappingId, auth);
            return rcReplace;
        }
        catch (GenericScheregException e) {
            this.logger.error("Failed to remove mapped concept", (Throwable)e);
            return null;
        }
    }
}

