/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import de.unibamberg.minf.dme.dao.interfaces.ReferenceDao;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.model.reference.Reference;
import de.unibamberg.minf.dme.model.reference.RootReference;
import de.unibamberg.minf.dme.service.interfaces.ReferenceService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReferenceServiceImpl
implements ReferenceService {
    @Autowired
    private ReferenceDao referenceDao;

    public Reference findReferenceByChildId(String rootElementId, String childId) {
        return this.referenceDao.findParentByChildId(rootElementId, childId);
    }

    public Reference findReferenceByChildId(Reference baseBeference, String childId) {
        return this.referenceDao.findParentByChildId(baseBeference, childId);
    }

    public Reference findReferenceBySchemaAndChildId(String schemaId, String childId) {
        if (schemaId != null) {
            return this.findReferenceByChildId(schemaId, childId);
        }
        return null;
    }

    public Reference findReferenceByChildId(String rootElementId, String childId, List<String> parentClassNames) {
        return this.referenceDao.findParentByChildId(rootElementId, childId, parentClassNames);
    }

    public Reference findReferenceByChildId(Reference reference, String childId, List<String> parentClassNames) {
        return this.referenceDao.findParentByChildId(reference, childId, parentClassNames);
    }

    public RootReference findReferenceBySchemaId(String schemaId) {
        return (RootReference)this.referenceDao.findById(schemaId);
    }

    public void saveRoot(RootReference root) {
        this.referenceDao.save((Identifiable)root);
    }

    public Reference findReferenceById(Reference root, String referenceId) {
        return this.referenceDao.findById(root, referenceId);
    }
}

