/*
 * Decompiled with CFR 0.152.
 */
package de.unibamberg.minf.dme.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import de.unibamberg.minf.dme.dao.interfaces.PersistedSessionDao;
import de.unibamberg.minf.dme.exception.GenericScheregException;
import de.unibamberg.minf.dme.model.LogEntry;
import de.unibamberg.minf.dme.model.PersistedSession;
import de.unibamberg.minf.dme.model.SessionSampleFile;
import de.unibamberg.minf.dme.model.base.Identifiable;
import de.unibamberg.minf.dme.service.interfaces.PersistedSessionService;
import de.unibamberg.minf.processing.model.SerializableResource;
import de.unibamberg.minf.processing.model.SerializableRootResource;
import de.unibamberg.minf.processing.model.base.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.types.ObjectId;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class PersistedSessionServiceImpl
implements PersistedSessionService {
    protected static final Logger logger = LoggerFactory.getLogger(PersistedSessionServiceImpl.class);
    @Autowired
    private PersistedSessionDao sessionDao;
    @Autowired
    private ObjectMapper objMapper;

    public List<PersistedSession> findAllByUser(String entityId, String userId) {
        if (userId == null) {
            return null;
        }
        return this.sessionDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId).and("entityId").is((Object)entityId)));
    }

    public SessionSampleFile saveAsSessionInputFile(File file, SessionSampleFile.FileTypes type, String sessionId) {
        return this.sessionDao.saveAsSessionInputFile(file, type, sessionId);
    }

    public SessionSampleFile saveAsSessionInputFile(String sample, SessionSampleFile.FileTypes type, String sessionId) {
        return this.sessionDao.saveAsSessionInputFile(sample, type, sessionId);
    }

    public void saveSessionData(String sessionData, String sessionId) throws JsonMappingException, JsonProcessingException {
        if (sessionData.isBlank()) {
            this.sessionDao.removeSessionData(sessionId);
        } else {
            JsonNode parsedJson = this.objMapper.readTree(sessionData);
            this.sessionDao.saveSessionData(sessionId, parsedJson);
        }
    }

    public JsonNode loadSessionData(String sessionId) {
        String sessionData = this.sessionDao.loadSessionData(sessionId);
        if (sessionData == null) {
            return MissingNode.getInstance();
        }
        try {
            return this.objMapper.readTree(sessionData);
        }
        catch (JsonProcessingException e) {
            logger.error("Failed to parse session data file");
            return MissingNode.getInstance();
        }
    }

    public PersistedSession setSampleFileType(PersistedSession session, SessionSampleFile.FileTypes fileType) {
        if (session.getSampleFile() == null || session.getSampleFile().getType().equals((Object)fileType)) {
            return session;
        }
        return this.sessionDao.updateSessionFileType(session.getId(), fileType);
    }

    public static InputStream getSampleInputStream(PersistedSession session) {
        if (session.getSampleFile() == null || session.getSampleFile().getPath() == null || !new File(session.getSampleFile().getPath()).exists()) {
            return null;
        }
        try {
            return new FileInputStream(session.getSampleFile().getPath());
        }
        catch (Exception e) {
            logger.error("Failed to open session sample file");
            return null;
        }
    }

    public List<PersistedSession> findExpiredSessions(DateTime cutoffTimestamp) {
        return this.sessionDao.find(Query.query((CriteriaDefinition)Criteria.where((String)"notExpiring").is((Object)false).and("lastAccessed").lte((Object)cutoffTimestamp)));
    }

    public PersistedSession accessOrCreate(String entityId, String httpSessionId, String userId) throws GenericScheregException {
        PersistedSession s = this.findSession(entityId, httpSessionId, userId);
        if (s == null) {
            if (userId != null) {
                s = this.findSession(entityId, httpSessionId, null);
                if (s != null) {
                    if (s.hasData()) {
                        s.setUserId(userId);
                        return this.saveSession(s);
                    }
                    this.deleteSession(s);
                    s = null;
                }
                if ((s = this.findLatest(entityId, userId)) != null) {
                    return this.reassignPersistedSession(httpSessionId, userId, s.getId());
                }
            }
            return this.createAndSaveSession(entityId, httpSessionId, userId);
        }
        return this.saveSession(s);
    }

    public PersistedSession get(String entityId, String httpSessionId, String userId) {
        PersistedSession s = this.findSession(entityId, httpSessionId, userId);
        if (s == null) {
            return null;
        }
        return s;
    }

    public String getSampleInputValue(PersistedSession s, String elementId) {
        Map selectedValueMap = this.loadSelectedValueMap(s.getId());
        if (selectedValueMap != null && selectedValueMap.containsKey(elementId)) {
            return (String)selectedValueMap.get(elementId);
        }
        return "";
    }

    public List<SerializableResource> getSelectedResources(PersistedSession s, String elementId) {
        List selectedValueMap = this.loadSelectedResourceMap(s.getId());
        if (selectedValueMap != null) {
            return selectedValueMap.stream().filter(r -> r.getElementId().equals(elementId)).collect(Collectors.toList());
        }
        return new ArrayList<SerializableResource>();
    }

    public List<SerializableRootResource> loadSampleOutput(String sessionId) {
        return this.sessionDao.loadSampleOutput(sessionId);
    }

    public List<SerializableRootResource> loadSampleMapped(String sessionId) {
        return this.sessionDao.loadSampleMapped(sessionId);
    }

    public Map<String, String> loadSelectedValueMap(String sessionId) {
        return this.sessionDao.loadSelectedValueMap(sessionId);
    }

    public List<SerializableResource> loadSelectedResourceMap(String sessionId) {
        return this.sessionDao.loadSelectedResourceMap(sessionId);
    }

    public void saveSampleOutput(String sessionId, List<Resource> sampleOutput) {
        this.sessionDao.saveSampleOutput(sessionId, sampleOutput);
    }

    public void saveSampleMapped(String sessionId, List<Resource> sampleMapped) {
        this.sessionDao.saveSampleMapped(sessionId, sampleMapped);
    }

    public void saveSelectedValueMap(String sessionId, Map<String, String> selectedValueMap) {
        this.sessionDao.saveSelectedValueMap(sessionId, selectedValueMap);
    }

    public void saveSelectedResourceMap(String sessionId, List<Resource> selectedResourceMap) {
        this.sessionDao.saveSelectedResourceMap(sessionId, selectedResourceMap);
    }

    public PersistedSession createAndSaveSession(String entityId, String httpSessionId, String userId) throws GenericScheregException {
        if (httpSessionId == null) {
            throw new GenericScheregException("PersistedSession can only be created on a valid http session -> none provided");
        }
        PersistedSession session = new PersistedSession();
        session.setId(new ObjectId().toString());
        session.setHttpSessionId(httpSessionId);
        session.setUserId(userId);
        session.setEntityId(entityId);
        session.addLogEntry(LogEntry.createEntry((LogEntry.LogType)LogEntry.LogType.INFO, (String)"~de.unibamberg.minf.dme.editor.sample.log.session_started", (Object[])new String[]{session.getId()}));
        session.setCreated(DateTime.now());
        return this.saveSession(session);
    }

    public PersistedSession reassignPersistedSession(String httpSessionId, String userId, String persistedSessionId) {
        PersistedSession s = (PersistedSession)this.sessionDao.findById(persistedSessionId);
        if (s != null) {
            PersistedSession sCurrent = this.findSession(s.getEntityId(), httpSessionId, userId);
            if (sCurrent != null) {
                if (sCurrent.getId().equals(persistedSessionId)) {
                    return sCurrent;
                }
                sCurrent.setHttpSessionId(s.getHttpSessionId());
                this.sessionDao.save((Identifiable)sCurrent);
            }
            s.setUserId(userId);
            s.setHttpSessionId(httpSessionId);
            return (PersistedSession)this.sessionDao.save((Identifiable)s);
        }
        return null;
    }

    public PersistedSession saveSession(PersistedSession session) {
        session.setLastAccessed(DateTime.now());
        return (PersistedSession)this.sessionDao.save((Identifiable)session);
    }

    public void deleteSession(String entityId, String httpSessionId, String userId) {
        this.deleteSession(this.findSession(entityId, httpSessionId, userId));
    }

    public void deleteSession(PersistedSession session) {
        if (session != null) {
            this.sessionDao.delete((Identifiable)session);
        }
    }

    public void deleteSessions(List<PersistedSession> sessions) {
        this.sessionDao.delete(sessions);
    }

    private PersistedSession findLatest(String entityId, String userId) {
        if (userId == null) {
            return null;
        }
        PersistedSession s = (PersistedSession)this.sessionDao.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)userId).and("entityId").is((Object)entityId)), Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"lastAccessed"}));
        if (s == null) {
            return null;
        }
        return s;
    }

    private PersistedSession findSession(String entityId, String httpSessionId, String userId) {
        if (userId == null) {
            return (PersistedSession)this.sessionDao.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"httpSessionId").is((Object)httpSessionId).and("entityId").is((Object)entityId).and("userId").exists(false)));
        }
        return (PersistedSession)this.sessionDao.findOne(Query.query((CriteriaDefinition)Criteria.where((String)"httpSessionId").is((Object)httpSessionId).and("entityId").is((Object)entityId).and("userId").is((Object)userId)));
    }
}

